/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;

public class ProcessUtils {
    static Logger log = Logger.getLogger(ProcessUtils.class.getName());

    private static int waitForProcessDeath(Process p, long timeout) {
        ProcessWaiter pw = new ProcessWaiter(p);
        Thread waiter = new Thread(pw);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for process", e);
        }
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        try {
            waiter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for dead process waiter", e);
        }
        InterruptedException ie = pw.getException();
        if (ie != null) {
            throw new ProcessStillAliveException("Timeout waiting for process to die", ie);
        }
        return p.exitValue();
    }

    public static int killProcess(Process process) {
        int exitValue;
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 1000L);
            ProcessUtils.closeAllStreamsAndDestroyProcess(process);
            if (exitValue == 0) {
                return exitValue;
            }
        }
        catch (Exception exception) {}
        process.destroy();
        try {
            exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
            ProcessUtils.closeAllStreamsAndDestroyProcess(process);
        }
        catch (ProcessStillAliveException ex) {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                throw ex;
            }
            try {
                log.info("Process didn't die after 10 seconds");
                ProcessUtils.kill9(process);
                exitValue = ProcessUtils.waitForProcessDeath(process, 10000L);
                ProcessUtils.closeAllStreamsAndDestroyProcess(process);
            }
            catch (Exception e) {
                log.warning("Process refused to die after 10 seconds, and couldn't kill9 it");
                e.printStackTrace();
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }

    private static void closeAllStreamsAndDestroyProcess(Process process) {
        Closeables.closeQuietly((Closeable)process.getInputStream());
        Closeables.closeQuietly((Closeable)process.getErrorStream());
        Closeables.closeQuietly((Closeable)process.getOutputStream());
        process.destroy();
    }

    private static int getProcessId(Process p) {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            throw new IllegalStateException("UnixUtils may not be used on Windows");
        }
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            Integer pid = (Integer)f.get(p);
            return pid;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't detect pid", e);
        }
    }

    private static void kill9(Integer pid) {
        log.fine("kill -9 " + pid);
        CommandLine command = new CommandLine("kill", "-9", pid.toString());
        command.execute();
        String result = command.getStdOut();
        int output = command.getExitCode();
        log.fine(String.valueOf(output));
        if (!command.isSuccessful()) {
            throw new RuntimeException("exec return code " + result + ": " + output);
        }
    }

    private static void kill9(Process p) {
        ProcessUtils.kill9(ProcessUtils.getProcessId(p));
    }

    public static class ProcessStillAliveException
    extends RuntimeException {
        public ProcessStillAliveException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ProcessWaiter
    implements Runnable {
        private volatile InterruptedException t;
        private final Process p;

        public InterruptedException getException() {
            return this.t;
        }

        public ProcessWaiter(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.t = e;
            }
        }
    }
}

