/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public abstract class AbstractResourceHandler
implements HttpHandler {
    private static final Pattern SINGLE_BYTE_RANGE;
    public static final Map<String, String> DEFAULT_MIME_TYPES;
    protected static final String DEFAULT_WELCOME_FILE_NAME = "index.html";
    private static final String DIRECTORY_LISTING_FORMAT_STRING = "<html><body><ol style='list-style-type: none; padding-left: 0px; margin-left: 0px;'>%s</ol></body></html>";
    protected final Executor ioThread;
    protected final Map<String, String> mimeTypes;
    protected String welcomeFileName;
    private boolean isDirectoryListingEnabled;

    static {
        HashMap<String, String> mimeTypes = new HashMap<String, String>();
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("csv", "text/csv");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("js", "text/javascript");
        mimeTypes.put("xhtml", "application/xhtml+xml");
        mimeTypes.put("json", "application/json");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("svg", "image/svg+xml");
        mimeTypes.put("ico", "image/vnd.microsoft.icon");
        DEFAULT_MIME_TYPES = Collections.unmodifiableMap(mimeTypes);
        SINGLE_BYTE_RANGE = Pattern.compile("bytes=(\\d+)?-(\\d+)?");
    }

    public AbstractResourceHandler(Executor ioThread) {
        this.ioThread = ioThread;
        this.mimeTypes = new HashMap<String, String>(DEFAULT_MIME_TYPES);
        this.welcomeFileName = DEFAULT_WELCOME_FILE_NAME;
    }

    public AbstractResourceHandler addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
        return this;
    }

    public AbstractResourceHandler welcomeFile(String welcomeFile) {
        this.welcomeFileName = welcomeFile;
        return this;
    }

    public AbstractResourceHandler directoryListingEnabled(boolean isDirectoryListingEnabled) {
        this.isDirectoryListingEnabled = isDirectoryListingEnabled;
        return this;
    }

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        this.ioThread.execute(this.createIOWorker(request, response, control));
    }

    protected void serve(final String mimeType, final ByteBuffer contents, HttpControl control, final HttpResponse response, final HttpRequest request) {
        control.execute(new Runnable(){

            @Override
            public void run() {
                response.header("Content-Type", mimeType);
                if (AbstractResourceHandler.this.maybeServeRange(request, contents, response)) {
                    return;
                }
                response.header("Content-Length", contents.remaining()).content(contents).end();
            }
        });
    }

    private boolean maybeServeRange(HttpRequest request, ByteBuffer contents, HttpResponse response) {
        String range = request.header("Range");
        if (range == null) {
            return false;
        }
        Matcher matcher = SINGLE_BYTE_RANGE.matcher(range);
        if (!matcher.matches()) {
            return false;
        }
        String startString = matcher.group(1);
        String endString = matcher.group(2);
        if (startString != null && endString != null) {
            int end;
            int start = Integer.parseInt(startString);
            if (start <= (end = Integer.parseInt(endString))) {
                this.serveRange(start, Math.min(contents.remaining() - 1, end), contents, response);
                return true;
            }
        } else {
            if (startString != null) {
                this.serveRange(Integer.parseInt(startString), contents.remaining() - 1, contents, response);
                return true;
            }
            if (endString != null) {
                int end = Integer.parseInt(endString);
                this.serveRange(contents.remaining() - end, contents.remaining() - 1, contents, response);
                return true;
            }
        }
        return false;
    }

    protected void serveRange(int start, int end, ByteBuffer contents, HttpResponse response) {
        if (start > contents.remaining()) {
            response.status(416).header("Content-Range", "bytes */" + contents.remaining()).end();
            return;
        }
        response.status(206).header("Content-Length", end - start + 1).header("Content-Range", "bytes " + start + "-" + end + "/" + contents.remaining());
        contents.limit(contents.position() + end + 1).position(contents.position() + start);
        response.content(contents).end();
    }

    protected abstract IOWorker createIOWorker(HttpRequest var1, HttpResponse var2, HttpControl var3);

    protected abstract class IOWorker
    implements Runnable {
        protected String path;
        private final HttpRequest request;
        protected final HttpResponse response;
        protected final HttpControl control;

        protected IOWorker(String path, HttpRequest request, HttpResponse response, HttpControl control) {
            this.path = path;
            this.request = request;
            this.response = response;
            this.control = control;
        }

        protected void notFound() {
            this.control.execute(new Runnable(){

                @Override
                public void run() {
                    IOWorker.this.control.nextHandler();
                }
            });
        }

        protected void error(final IOException exception) {
            this.control.execute(new Runnable(){

                @Override
                public void run() {
                    IOWorker.this.response.error(exception);
                }
            });
        }

        @Override
        public void run() {
            this.path = this.withoutQuery(this.path);
            try {
                ByteBuffer content = null;
                if (!this.exists()) {
                    this.notFound();
                } else {
                    content = this.fileBytes();
                    if (content != null) {
                        AbstractResourceHandler.this.serve(this.guessMimeType(this.path), content, this.control, this.response, this.request);
                    } else {
                        if (!this.path.endsWith("/")) {
                            this.response.status(301).header("Location", String.valueOf(this.path) + "/").end();
                            return;
                        }
                        content = this.welcomeBytes();
                        if (content != null) {
                            AbstractResourceHandler.this.serve(this.guessMimeType(AbstractResourceHandler.this.welcomeFileName), content, this.control, this.response, this.request);
                        } else if (AbstractResourceHandler.this.isDirectoryListingEnabled && (content = this.directoryListingBytes()) != null) {
                            AbstractResourceHandler.this.serve(this.guessMimeType(".html"), content, this.control, this.response, this.request);
                        } else {
                            this.notFound();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.error(e);
            }
        }

        protected abstract boolean exists() throws IOException;

        protected abstract ByteBuffer fileBytes() throws IOException;

        protected abstract ByteBuffer welcomeBytes() throws IOException;

        protected abstract ByteBuffer directoryListingBytes() throws IOException;

        protected ByteBuffer formatFileListAsHtml(File[] files) throws IOException {
            StringBuilder builder = new StringBuilder();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                builder.append("<li><a href=\"").append(file.getName()).append("\">").append(file.getName()).append("</a></li>");
                ++n2;
            }
            String formattedString = String.format(AbstractResourceHandler.DIRECTORY_LISTING_FORMAT_STRING, builder.toString());
            byte[] formattedBytes = formattedString.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(formattedBytes);
            return this.read(formattedBytes.length, inputStream);
        }

        protected ByteBuffer read(int length, InputStream in) throws IOException {
            byte[] data = new byte[length];
            try {
                int read = 0;
                while (read < length) {
                    int more = in.read(data, read, data.length - read);
                    if (more == -1) {
                        break;
                    }
                    read += more;
                }
            }
            finally {
                in.close();
            }
            return ByteBuffer.wrap(data);
        }

        private String guessMimeType(String path) {
            int lastDot = path.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            String extension = path.substring(lastDot + 1).toLowerCase();
            String mimeType = AbstractResourceHandler.this.mimeTypes.get(extension);
            if (mimeType == null) {
                return null;
            }
            if (mimeType.startsWith("text/") && this.response.charset() != null) {
                mimeType = String.valueOf(mimeType) + "; charset=" + this.response.charset().name();
            }
            return mimeType;
        }

        protected String withoutQuery(String path) {
            int queryStart = path.indexOf(63);
            if (queryStart > -1) {
                path = path.substring(0, queryStart);
            }
            return path;
        }
    }
}

