/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;

public class EmbeddedResourceHandler
extends AbstractResourceHandler {
    private final File root;

    public EmbeddedResourceHandler(String root, Executor ioThread) {
        super(ioThread);
        this.root = new File(root);
    }

    public EmbeddedResourceHandler(String root) {
        this(root, Executors.newFixedThreadPool(4));
    }

    @Override
    protected AbstractResourceHandler.IOWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new ResourceWorker(request, response, control);
    }

    protected class ResourceWorker
    extends AbstractResourceHandler.IOWorker {
        private InputStream resource;
        private InputStream content;
        private File file;

        protected ResourceWorker(HttpRequest request, HttpResponse response, HttpControl control) {
            super(request.uri(), request, response, control);
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = new File(EmbeddedResourceHandler.this.root, this.path);
            this.resource = this.getResource(this.file);
            return this.resource != null;
        }

        @Override
        protected ByteBuffer fileBytes() throws IOException {
            this.content = this.resource;
            if (this.content == null || this.content instanceof ByteArrayInputStream) {
                return null;
            }
            return this.read(this.content);
        }

        @Override
        protected ByteBuffer welcomeBytes() throws IOException {
            InputStream resourceStream = this.getResource(new File(this.file, EmbeddedResourceHandler.this.welcomeFileName));
            return resourceStream == null ? null : this.read(resourceStream);
        }

        @Override
        protected ByteBuffer directoryListingBytes() throws IOException {
            URL resourceURL = this.getClass().getClassLoader().getResource(this.getPath(this.file));
            try {
                File directory = new File(resourceURL.toURI());
                return directory.isDirectory() ? this.formatFileListAsHtml(directory.listFiles()) : null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        private ByteBuffer read(InputStream content) throws IOException {
            try {
                return this.read(content.available(), content);
            }
            catch (NullPointerException happensWhenReadingDirectoryPathInJar) {
                return null;
            }
        }

        private InputStream getResource(File file) throws IOException {
            return this.getClass().getClassLoader().getResourceAsStream(this.getPath(file));
        }

        private String getPath(File file) {
            String resourcePath = file.getPath();
            if ('/' != File.separatorChar) {
                resourcePath = resourcePath.replace(File.separatorChar, '/');
            }
            return resourcePath;
        }
    }
}

