/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.helpers.UTF8Exception;
import org.webbitserver.helpers.UTF8Output;
import org.webbitserver.netty.CatchingRunnable;
import org.webbitserver.netty.NettyWebSocketConnection;

public class DecodingHybiFrame {
    private final int opcode;
    private final UTF8Output utf8Output;
    private List<ChannelBuffer> fragments = new ArrayList<ChannelBuffer>();
    private int length;

    public DecodingHybiFrame(int opcode, UTF8Output utf8Output, ChannelBuffer fragment) throws UTF8Exception {
        this.opcode = opcode;
        this.utf8Output = utf8Output;
        this.append(fragment);
    }

    public void append(ChannelBuffer fragment) throws UTF8Exception {
        this.length += fragment.readableBytes();
        if (this.opcode == 1) {
            this.utf8Output.write(fragment.array());
        } else {
            this.fragments.add(fragment);
        }
    }

    private byte[] messageBytes() {
        byte[] result = new byte[this.length];
        int offset = 0;
        for (ChannelBuffer fragment : this.fragments) {
            byte[] array = fragment.array();
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public void dispatchMessage(final WebSocketHandler handler, final NettyWebSocketConnection connection, Executor executor, Thread.UncaughtExceptionHandler exceptionHandler) throws UTF8Exception {
        switch (this.opcode) {
            case 1: {
                final String messageValue = this.utf8Output.getStringAndRecycle();
                executor.execute(new CatchingRunnable(exceptionHandler){

                    @Override
                    protected void go() throws Throwable {
                        handler.onMessage((WebSocketConnection)connection, messageValue);
                    }
                });
                return;
            }
            case 2: {
                final byte[] bytes = this.messageBytes();
                executor.execute(new CatchingRunnable(exceptionHandler){

                    @Override
                    public void go() throws Throwable {
                        handler.onMessage((WebSocketConnection)connection, bytes);
                    }
                });
                return;
            }
            case 9: {
                final byte[] bytes = this.messageBytes();
                executor.execute(new CatchingRunnable(exceptionHandler){

                    @Override
                    protected void go() throws Throwable {
                        handler.onPing(connection, bytes);
                    }
                });
                return;
            }
            case 10: {
                final byte[] bytes = this.messageBytes();
                executor.execute(new CatchingRunnable(exceptionHandler){

                    @Override
                    protected void go() throws Throwable {
                        handler.onPong(connection, bytes);
                    }
                });
                return;
            }
        }
        throw new IllegalStateException("Unexpected opcode:" + this.opcode);
    }
}

