/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriverException;

public enum OperaProduct {
    CORE("core-gogi"),
    DESKTOP("desktop"),
    SDK("sdk"),
    MOBILE("mobile"),
    MINI("mini"),
    ALL(""){

        @Override
        public boolean is(OperaProduct compareWith) {
            return true;
        }
    };

    private final String product;
    private static final Map<String, OperaProduct> lookup;

    private OperaProduct(String product) {
        this.product = product;
    }

    public String toString() {
        return this.product;
    }

    public boolean is(OperaProduct compareWith) {
        return this.equals((Object)compareWith);
    }

    public static OperaProduct get(String product) {
        if (!lookup.containsKey(product)) {
            throw new WebDriverException("Unknown product: " + product);
        }
        return lookup.get(product);
    }

    static {
        lookup = new HashMap<String, OperaProduct>();
        for (OperaProduct p : OperaProduct.values()) {
            lookup.put(p.toString(), p);
        }
    }
}

