/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.WaitState;
import com.opera.core.systems.model.ICommand;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.scope.ScopeCommand;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.handlers.IConnectionHandler;
import com.opera.core.systems.scope.handlers.ScopeEventHandler;
import com.opera.core.systems.scope.internal.OperaFlags;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.ScopeProtos;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ICookieManager;
import com.opera.core.systems.scope.services.ICoreUtils;
import com.opera.core.systems.scope.services.IDesktopUtils;
import com.opera.core.systems.scope.services.IDesktopWindowManager;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.scope.services.IPrefs;
import com.opera.core.systems.scope.services.ISelftest;
import com.opera.core.systems.scope.services.IWindowManager;
import com.opera.core.systems.scope.services.ums.SystemInputManager;
import com.opera.core.systems.scope.services.ums.UmsServices;
import com.opera.core.systems.scope.stp.StpConnection;
import com.opera.core.systems.scope.stp.StpThread;
import com.opera.core.systems.util.VersionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;

public class ScopeServices
implements IConnectionHandler {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, String> versions;
    private final StpThread stpThread;
    private final AtomicInteger tagCounter;
    private ICoreUtils coreUtils;
    private IEcmaScriptDebugger debugger;
    private IOperaExec exec;
    private IWindowManager windowManager;
    private IDesktopWindowManager desktopWindowManager;
    private IDesktopUtils desktopUtils;
    private IPrefs prefs;
    private SystemInputManager systemInputManager;
    private ScopeProtos.HostInfo hostInfo;
    private ICookieManager cookieManager;
    private ISelftest selftest;
    private WaitState waitState = new WaitState();
    private StpConnection connection = null;
    private List<String> listedServices;
    private StringBuilder selftestOutput;
    private boolean shutdown = false;

    public ScopeServices(Map<String, String> requiredServices, int port, boolean manualConnect) throws IOException {
        this.versions = requiredServices;
        this.tagCounter = new AtomicInteger();
        this.stpThread = new StpThread(port, this, new ScopeEventHandler(this), manualConnect);
        this.selftestOutput = new StringBuilder();
    }

    public void init() {
        this.waitForHandshake();
        this.hostInfo = this.getHostInfo();
        this.createUmsServices(OperaFlags.ENABLE_DEBUGGER, this.hostInfo);
        this.connect();
        ArrayList<String> wantedServices = new ArrayList<String>();
        boolean ecmascriptService = false;
        for (ScopeProtos.Service service : this.hostInfo.getServiceListList()) {
            if (!service.getName().equals("ecmascript")) continue;
            ecmascriptService = true;
            break;
        }
        if (ecmascriptService) {
            wantedServices.add("ecmascript");
        } else {
            wantedServices.add("ecmascript-debugger");
        }
        wantedServices.add("exec");
        wantedServices.add("window-manager");
        wantedServices.add("core");
        if (this.versions.containsKey("prefs")) {
            wantedServices.add("prefs");
        }
        if (this.versions.containsKey("desktop-window-manager")) {
            wantedServices.add("desktop-window-manager");
        }
        if (this.versions.containsKey("system-input")) {
            wantedServices.add("system-input");
        }
        if (this.versions.containsKey("desktop-utils")) {
            wantedServices.add("desktop-utils");
        }
        if (this.versions.containsKey("selftest")) {
            wantedServices.add("selftest");
        }
        wantedServices.add("cookie-manager");
        this.enableServices(wantedServices);
        this.initializeServices(OperaFlags.ENABLE_DEBUGGER);
    }

    private void initializeServices(boolean enableDebugger) {
        this.exec.init();
        this.windowManager.init();
        if (this.versions.containsKey("core") && this.coreUtils != null) {
            this.coreUtils.init();
        }
        if (this.versions.containsKey("prefs") && this.prefs != null) {
            this.prefs.init();
        }
        if (this.versions.containsKey("desktop-window-manager") && this.desktopWindowManager != null) {
            this.desktopWindowManager.init();
        }
        if (this.versions.containsKey("system-input") && this.systemInputManager != null) {
            this.systemInputManager.init();
        }
        if (this.versions.containsKey("desktop-utils") && this.desktopUtils != null) {
            this.desktopUtils.init();
        }
        if (enableDebugger) {
            this.debugger.init();
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.isConnected()) {
            this.connection.close();
        }
        this.stpThread.shutdown();
        try {
            this.stpThread.join();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void waitForHandshake() throws WebDriverException {
        try {
            this.waitState.waitForHandshake(OperaIntervals.HANDSHAKE_TIMEOUT.getValue());
        }
        catch (WebDriverException e) {
            this.shutdown();
            throw e;
        }
    }

    private ScopeProtos.HostInfo getHostInfo() {
        UmsProtos.Response response = this.executeCommand(ScopeCommand.HOST_INFO, null);
        try {
            return ScopeProtos.HostInfo.parseFrom(response.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new WebDriverException("Error while parsing host info", (Throwable)e);
        }
    }

    private void createUmsServices(boolean enableDebugger, ScopeProtos.HostInfo info) {
        new UmsServices(this, info);
        if (!enableDebugger) {
            this.debugger = new IEcmaScriptDebugger(){

                @Override
                public void setRuntime(EsdbgProtos.RuntimeInfo runtime) {
                }

                @Override
                public Object scriptExecutor(String script, Object ... params) {
                    return null;
                }

                @Override
                public void removeRuntime(int runtimeId) {
                }

                @Override
                public List<String> listFramePaths() {
                    return null;
                }

                @Override
                public void init() {
                }

                @Override
                public int getRuntimeId() {
                    return 0;
                }

                @Override
                public Integer getObject(String using) {
                    return null;
                }

                @Override
                public Integer executeScriptOnObject(String using, int objectId) {
                    return null;
                }

                @Override
                public Object executeScript(String using, boolean responseExpected) {
                    return null;
                }

                @Override
                public String executeJavascript(String using, boolean responseExpected) {
                    return null;
                }

                @Override
                public String executeJavascript(String using) {
                    return null;
                }

                @Override
                public List<Integer> examineObjects(Integer id) {
                    return null;
                }

                @Override
                public void cleanUpRuntimes() {
                }

                @Override
                public void cleanUpRuntimes(int windowId) {
                }

                @Override
                public void changeRuntime(String framePath) {
                }

                @Override
                public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
                    return null;
                }

                @Override
                public String callFunctionOnObject(String using, int objectId) {
                    return null;
                }

                @Override
                public void addRuntime(EsdbgProtos.RuntimeInfo info) {
                }

                @Override
                public void releaseObjects() {
                }

                @Override
                public boolean updateRuntime() {
                    return false;
                }

                @Override
                public void resetRuntimesList() {
                }

                @Override
                public void readyStateChanged(EcmascriptProtos.ReadyStateChange change) {
                }

                @Override
                public void releaseObject(int objectId) {
                }

                @Override
                public void resetFramePath() {
                }

                @Override
                public void changeRuntime(int index) {
                }

                @Override
                public String executeJavascript(String using, Integer windowId) {
                    return null;
                }

                @Override
                public Object examineScriptResult(Integer id) {
                    return null;
                }

                @Override
                public void setDriver(OperaDriver driver) {
                }
            };
        }
    }

    private void connect() {
        ScopeProtos.ClientInfo.Builder info = ScopeProtos.ClientInfo.newBuilder().setFormat("protobuf");
        this.executeCommand(ScopeCommand.CONNECT, (AbstractMessage.Builder<?>)info);
    }

    public void enableServices(List<String> requiredServices) {
        for (String requiredService : requiredServices) {
            try {
                if (!this.getListedServices().contains(requiredService)) continue;
                this.enable(requiredService);
            }
            catch (InvalidProtocolBufferException e) {
                throw new WebDriverException("Could not parse the message", (Throwable)e);
            }
        }
    }

    private ScopeProtos.ServiceResult enable(String serviceName) throws InvalidProtocolBufferException {
        ScopeProtos.ServiceSelection.Builder selection = ScopeProtos.ServiceSelection.newBuilder();
        selection.setName(serviceName);
        UmsProtos.Response response = this.executeCommand(ScopeCommand.ENABLE, (AbstractMessage.Builder<?>)selection);
        return ScopeProtos.ServiceResult.parseFrom(response.getPayload());
    }

    public void quitOpera(OperaRunner runner) {
        block9: {
            if (!this.isConnected()) {
                return;
            }
            try {
                if (this.exec.getActionList().contains("Quit")) {
                    this.exec.action("Quit", new String[0]);
                } else {
                    this.exec.action("Exit", new String[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof CommunicationException) break block9;
                this.logger.warning("Caught exception on shut down: " + e.getMessage());
            }
        }
        if (runner != null) {
            long interval = OperaIntervals.QUIT_POLL_INTERVAL.getValue();
            for (long timeout = OperaIntervals.QUIT_RESPONSE_TIMEOUT.getValue(); runner.isOperaRunning() && timeout > 0L; timeout -= interval) {
                try {
                    Thread.sleep(interval);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public void quit() {
        this.quit(null);
    }

    public void quit(OperaRunner runner) {
        this.quitOpera(runner);
        this.shutdown();
    }

    @Override
    public boolean onConnected(StpConnection con) {
        this.logger.finest("onConnect fired");
        if (this.connection == null) {
            this.logger.finest("Got StpConnection");
            this.connection = con;
            return true;
        }
        this.logger.warning("StpConnection already attached - closing incoming connection.");
        return false;
    }

    @Override
    public void onServiceList(List<String> services) {
        this.setListedServices(services);
    }

    public void onWindowLoaded(int id) {
        this.logger.finest("Window loaded: windowId=" + id);
        this.waitState.onWindowLoaded(id);
    }

    public void onWindowClosed(int id) {
        this.logger.finest("Window closed: windowId=" + id);
        this.waitState.onWindowClosed(id);
    }

    public void onDesktopWindowShown(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow shown: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowShown(info);
    }

    public void onDesktopWindowUpdated(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow updated: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowUpdated(info);
    }

    public void onDesktopWindowClosed(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow closed: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowClosed(info);
    }

    public void onDesktopWindowActivated(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow active: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowActivated(info);
    }

    public void onDesktopWindowLoaded(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow loaded: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowLoaded(info);
    }

    public void onQuickMenuShown(DesktopWmProtos.QuickMenuInfo info) {
        this.logger.finest("QuickMenu shown: menuName=" + info.getMenuId().getMenuName());
        this.waitState.onQuickMenuShown(info);
    }

    public void onQuickMenuItemPressed(DesktopWmProtos.QuickMenuItemID menuItemID) {
        this.logger.finest("QuickMenu shown: menuItem=" + menuItemID.getMenuText());
        this.waitState.onQuickMenuItemPressed(menuItemID);
    }

    public void onQuickMenuClosed(DesktopWmProtos.QuickMenuID id) {
        this.logger.finest("QuickMenu closed");
        this.waitState.onQuickMenuClosed(id);
    }

    @Override
    public void onHandshake(boolean stp1) {
        this.logger.finest("Got Stp handshake!");
        this.waitState.onHandshake();
    }

    @Override
    public void onDisconnect() {
        this.logger.fine("Disconnected, closing STP connection");
        if (this.isConnected() && !this.shutdown) {
            this.waitState.onDisconnected();
            this.connection = null;
        }
    }

    public void onOperaIdle() {
        this.logger.finest("idle: Got idle event");
        this.waitState.onOperaIdle();
    }

    public void onSelftestOutput(SelftestProtos.SelftestOutput output) {
        this.selftestOutput = this.selftestOutput.append(output.getOutput());
    }

    public void onSelftestDone() {
        String results = this.selftestOutput.toString();
        this.selftestOutput = new StringBuilder();
        this.waitState.onSelftestDone(results);
    }

    public String selftest(List<String> modules, long timeout) {
        if (this.selftest == null) {
            throw new UnsupportedOperationException("selftest service is not supported");
        }
        this.selftest.runSelftests(modules);
        return this.waitState.waitForSelftestDone(timeout);
    }

    public void waitForWindowLoaded(int activeWindowId, long timeout) {
        this.logger.finest("waitForWindowLoaded with params activeWindowId=" + activeWindowId + " timeout=" + timeout);
        this.waitState.waitForWindowLoaded(activeWindowId, timeout);
    }

    public boolean isOperaIdleAvailable() {
        for (ScopeProtos.Service service : this.hostInfo.getServiceListList()) {
            if (!service.getName().equals("core")) continue;
            String version = service.getVersion();
            boolean ok = VersionUtil.compare(version, "1.1") >= 0;
            this.logger.finest("core service version check: " + ok + " (" + version + ")");
            return ok;
        }
        this.logger.severe("core service not found");
        return false;
    }

    public void captureOperaIdle() {
        this.logger.finer("idle: Capturing idle event");
        this.waitState.captureOperaIdle();
    }

    public void waitForOperaIdle(long timeout) {
        this.logger.finest("idle: Waiting for (timeout = " + timeout + ")");
        this.waitState.waitForOperaIdle(timeout);
        this.logger.finest("idle: Finished waiting");
    }

    public void waitStart() {
        this.waitState.setWaitEvents(true);
    }

    public int waitForDesktopWindowLoaded(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowLoaded(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowShown(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowShown(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowUpdated(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowUpdated(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowActivated(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowActivated(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowClosed(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowClosed(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String waitForMenuShown(String menuName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuShown(menuName, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String waitForMenuClosed(String menuName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuClosed(menuName, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String waitForMenuItemPressed(String menuItemText, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuItemPressed(menuItemText, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void onResponseReceived(int tag, UmsProtos.Response response) {
        if (this.isConnected()) {
            this.logger.finest("Got response");
            if (response != null) {
                this.waitState.onResponse(tag, response);
            } else {
                this.waitState.onError(tag);
            }
        }
    }

    @Override
    public void onException(Exception exception) {
        if (this.isConnected()) {
            this.waitState.onException(exception);
            this.connection = null;
        }
    }

    public String getMinVersionFor(String service) {
        return this.versions.get(service);
    }

    private UmsProtos.Response waitForResponse(int tag, long timeout) {
        try {
            return this.waitState.waitFor(tag, timeout);
        }
        catch (WebDriverException e) {
            this.shutdown();
            throw e;
        }
    }

    public void setListedServices(List<String> services) {
        this.listedServices = services;
    }

    public List<String> getListedServices() {
        return this.listedServices;
    }

    public void close() {
        this.connection.close();
    }

    private UmsProtos.Command.Builder buildCommand(ICommand command, ByteString payload) {
        UmsProtos.Command.Builder cb = UmsProtos.Command.newBuilder();
        cb.setCommandID(command.getCommandID());
        cb.setFormat(0);
        cb.setService(command.getServiceName());
        cb.setTag(this.tagCounter.incrementAndGet());
        cb.setPayload(payload);
        return cb;
    }

    public UmsProtos.Response executeCommand(ICommand command, AbstractMessage.Builder<?> builder) {
        return this.executeCommand(command, builder, OperaIntervals.RESPONSE_TIMEOUT.getValue());
    }

    public UmsProtos.Response executeCommand(ICommand command, AbstractMessage.Builder<?> builder, long timeout) {
        ByteString payload = builder != null ? builder.build().toByteString() : ByteString.EMPTY;
        UmsProtos.Command.Builder commandBuilder = this.buildCommand(command, payload);
        int tag = commandBuilder.getTag();
        this.connection.send(commandBuilder.build());
        return this.waitForResponse(tag, timeout);
    }

    public void startStpThread() {
        this.stpThread.start();
    }

    public void onRequest(int windowId) {
        this.logger.fine("Window closed: windowId=" + windowId);
        this.waitState.onRequest(windowId);
    }

    public Map<String, String> getVersions() {
        return this.versions;
    }

    public StpConnection getConnection() {
        return this.connection;
    }

    public IEcmaScriptDebugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(IEcmaScriptDebugger debugger) {
        this.debugger = debugger;
    }

    public IOperaExec getExec() {
        return this.exec;
    }

    public void setExec(IOperaExec exec) {
        this.exec = exec;
    }

    public IWindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(IWindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public ICoreUtils getCoreUtils() {
        return this.coreUtils;
    }

    public void setCoreUtils(ICoreUtils coreUtils) {
        this.coreUtils = coreUtils;
    }

    public IPrefs getPrefs() {
        return this.prefs;
    }

    public void setPrefs(IPrefs prefs) {
        this.prefs = prefs;
    }

    public IDesktopWindowManager getDesktopWindowManager() {
        return this.desktopWindowManager;
    }

    public void setDesktopWindowManager(IDesktopWindowManager desktopWindowManager) {
        this.desktopWindowManager = desktopWindowManager;
    }

    public IDesktopUtils getDesktopUtils() {
        return this.desktopUtils;
    }

    public void setDesktopUtils(IDesktopUtils desktopUtils) {
        this.desktopUtils = desktopUtils;
    }

    public SystemInputManager getSystemInputManager() {
        return this.systemInputManager;
    }

    public void setSystemInputManager(SystemInputManager manager) {
        this.systemInputManager = manager;
    }

    public ICookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(ICookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public ISelftest getSelftest() {
        return this.selftest;
    }

    public void setSelftest(ISelftest selftest) {
        this.selftest = selftest;
    }
}

