/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.arguments;

public class OperaArgument {
    private String argument;
    private String value;

    public OperaArgument(String argument) {
        this.argument = OperaArgument.sanitize(argument);
    }

    public OperaArgument(String argument, String value) {
        this.argument = OperaArgument.sanitize(argument);
        this.value = value;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getValue() {
        return this.value;
    }

    private static String sanitize(String key) {
        for (OperaArgumentSign sign : OperaArgumentSign.values()) {
            if (!OperaArgument.hasSwitch(key, sign.sign).booleanValue()) continue;
            return key.substring(sign.sign.length());
        }
        return key;
    }

    private static Boolean hasSwitch(String key, String sign) {
        return key.length() > sign.length() && key.substring(0, sign.length()).equals(sign);
    }

    public static enum OperaArgumentSign {
        GNU_SIGN("--"),
        POSIX_SIGN("-"),
        WINDOWS_SIGN("/");

        private final String sign;

        private OperaArgumentSign(String sign) {
            this.sign = sign;
        }

        public String getValue() {
            return this.sign;
        }
    }
}

