/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.preferences;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.opera.core.systems.preferences.AbstractOperaPreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.openqa.selenium.WebDriverException;

public class OperaFilePreferences
extends AbstractOperaPreferences {
    private File preferenceFile;

    public OperaFilePreferences(File preferenceFile) {
        this.preferenceFile = preferenceFile;
        if (!preferenceFile.exists()) {
            try {
                if (!preferenceFile.createNewFile()) {
                    throw new IOException("File exists");
                }
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to create new preference file: " + e.getMessage());
            }
            return;
        }
        Ini ini = this.getIniForPreferenceFile(preferenceFile);
        for (Map.Entry section : ini.entrySet()) {
            for (Map.Entry entry : ((Profile.Section)section.getValue()).entrySet()) {
                this.set(((Profile.Section)section.getValue()).getName(), (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Ini getIniForPreferenceFile(File preferenceFile) {
        try {
            List lines = Files.readLines((File)preferenceFile, (Charset)Charsets.UTF_8);
            Iterable filteredLines = Iterables.filter((Iterable)lines, (Predicate)new Predicate<String>(){

                public boolean apply(String line) {
                    return !line.contains("Opera Preferences version");
                }
            });
            return new Ini((Reader)new StringReader(Joiner.on((String)"\n").join(filteredLines)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void set(String section, String key, Object value) {
        this.set(new FilePreference(this, section, key, value));
    }

    @Override
    public void set(OperaPreferences.OperaPreference preference) {
        if (!(preference instanceof FilePreference)) {
            super.set(FilePreference.convert(this, preference));
        } else {
            super.set(preference);
        }
        this.write();
    }

    public void write() {
        try {
            Wini ini = new Wini(this.preferenceFile);
            for (OperaPreferences.OperaPreference p : this) {
                ini.put(p.getSection(), p.getKey(), ((AbstractOperaPreferences.AbstractPreference)p).getValue(true));
            }
            ini.store(this.preferenceFile);
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to write to preference file: " + e.getMessage());
        }
    }

    public static class FilePreference
    extends AbstractOperaPreferences.AbstractPreference {
        private OperaFilePreferences parent;

        public FilePreference(OperaFilePreferences parent, String section, String key, Object value) {
            super(section, key, value);
            this.parent = parent;
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            this.parent.write();
        }

        public static FilePreference convert(OperaFilePreferences parent, OperaPreferences.OperaPreference convertee) {
            return new FilePreference(parent, convertee.getSection(), convertee.getKey(), convertee.getValue());
        }
    }
}

