/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.preferences;

import com.opera.core.systems.model.OperaColor;
import com.opera.core.systems.preferences.AbstractOperaPreferences;
import com.opera.core.systems.preferences.OperaGenericPreferences;
import com.opera.core.systems.preferences.OperaPreferences;
import com.opera.core.systems.scope.protos.PrefsProtos;
import com.opera.core.systems.scope.services.IPrefs;
import java.io.File;
import java.lang.reflect.Type;
import org.openqa.selenium.WebDriverException;

public class OperaScopePreferences
extends AbstractOperaPreferences {
    protected IPrefs service;

    public OperaScopePreferences(IPrefs prefsService) {
        this.service = prefsService;
        this.updatePreferenceCache();
    }

    @Override
    public void set(OperaPreferences.OperaPreference preference) {
        for (OperaPreferences.OperaPreference p : this) {
            if (!p.getSection().equalsIgnoreCase(preference.getSection()) || !p.getKey().equalsIgnoreCase(preference.getKey())) continue;
            if (!p.getValue().equals(preference.getValue())) {
                p.setValue(((OperaGenericPreferences.GenericPreference)preference).getValue(true));
            }
            return;
        }
        throw new WebDriverException("Unknown preference: " + ((Object)preference).toString());
    }

    @Override
    public void set(String section, String key, Object value) {
        this.set(new OperaGenericPreferences.GenericPreference(section, key, value));
    }

    @Override
    public ScopePreference get(String section, String key) {
        return (ScopePreference)super.get(section, key);
    }

    public void resetAll() {
        for (OperaPreferences.OperaPreference p : this) {
            ((ScopePreference)p).reset();
        }
    }

    private void updatePreferenceCache() {
        for (PrefsProtos.Pref pref : this.service.listPrefs(true, null)) {
            this.preferences.add(new ScopePreference(this, pref));
        }
    }

    public static class ScopePreference
    extends AbstractOperaPreferences.AbstractPreference {
        private OperaScopePreferences parent;
        private PrefsProtos.Pref pref;

        public ScopePreference(OperaScopePreferences parent, PrefsProtos.Pref pref) {
            super(pref.getSection(), pref.getKey(), pref.getValue());
            this.parent = parent;
            this.pref = pref;
        }

        @Override
        public Object getValue() {
            String value = super.getValue().toString();
            switch (PrefType.toJava(this.pref.getType())) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
                case COLOR: {
                    return OperaColor.decode(value);
                }
                case FILE: {
                    return new File(value);
                }
                case INTEGER: {
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        return value;
                    }
                }
            }
            return value;
        }

        @Override
        public void setValue(Object value) {
            super.setValue(value);
            this.parent.service.setPrefs(this.getSection(), this.getKey(), super.getValue(true).toString());
        }

        @Override
        public Object getDefaultValue() {
            return this.parent.service.getPref(this.getSection(), this.getKey(), PrefsProtos.GetPrefArg.Mode.DEFAULT);
        }

        public Type getType() {
            switch (PrefType.toJava(this.pref.getType())) {
                case BOOLEAN: {
                    return Boolean.class;
                }
                case COLOR: {
                    return OperaColor.class;
                }
                case FILE: {
                    return File.class;
                }
                case INTEGER: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        public boolean isEnabled() {
            return this.pref.getEnabled();
        }

        public void reset() {
            this.setValue(this.getDefaultValue());
        }
    }

    private static enum PrefType {
        BOOLEAN,
        COLOR,
        FILE,
        INTEGER,
        STRING;


        public static PrefType toJava(PrefsProtos.Pref.Type type) {
            switch (type) {
                case BOOLEAN: {
                    return BOOLEAN;
                }
                case COLOR: {
                    return COLOR;
                }
                case DIRECTORY: 
                case FILE: 
                case REQUIRED_FILE: {
                    return FILE;
                }
                case INTEGER: {
                    return INTEGER;
                }
            }
            return STRING;
        }
    }
}

