/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.ProcessUtils;

public class OperaLauncherBinary
extends Thread {
    private static final String launcherLoggingOutputExpression = "^\\[(\\w+)\\]";
    private final Process process;
    private final OutputWatcher watcher;
    private final Thread outputWatcherThread;
    private final List<String> commands = new LinkedList<String>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final AtomicBoolean running = new AtomicBoolean(false);

    public OperaLauncherBinary(String location, String ... args) throws IOException {
        super(new ThreadGroup("run-process"), "launcher");
        this.commands.add(location);
        if (args != null && args.length > 0) {
            this.commands.addAll(Arrays.asList(args));
        }
        ProcessBuilder builder = new ProcessBuilder(this.commands);
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
            this.watcher = new OutputWatcher(this.process);
            this.outputWatcherThread = new Thread(this.getThreadGroup(), this.watcher, "output-watcher");
            this.outputWatcherThread.setDaemon(true);
            this.running.set(true);
            this.outputWatcherThread.start();
        }
        catch (IOException e) {
            if (Platform.getCurrent().is(Platform.WINDOWS)) {
                throw new IOException("Could not start the launcher process, make sure you have the Microsoft Visual C++ 2008 Redistributable Package installed on your system: " + e.getMessage());
            }
            throw new IOException(e);
        }
        try {
            OperaLauncherBinary.waitFor(OperaIntervals.PROCESS_START_SLEEP.getValue());
            if (this.process.exitValue() > 0) {
                throw new IOException("exited immediately; possibly incorrect command-line arguments?  Commands: " + this.commands);
            }
        }
        catch (IllegalThreadStateException e) {
            // empty catch block
        }
    }

    public String getCommands() {
        return this.commands.toString();
    }

    public void kill() {
        this.watcher.kill();
    }

    public void shutdown() {
        this.kill();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        this.logger.fine("Waiting for launcher binary to exit");
        while (this.running.get()) {
            try {
                int exit = this.process.waitFor();
                this.logger.fine("Launcher exited with return value " + exit);
                this.running.set(false);
            }
            catch (InterruptedException e) {
                this.logger.warning("Got interrupted, will terminate launcher");
                this.process.destroy();
            }
        }
    }

    private static void waitFor(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class OutputWatcher
    implements Runnable {
        private Process process;

        public OutputWatcher(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            OperaLauncherBinary.this.logger.finer("Running launcher: " + OperaLauncherBinary.this.running.get());
            InputStream stream = this.process.getInputStream();
            Pattern pattern = Pattern.compile(OperaLauncherBinary.launcherLoggingOutputExpression);
            String buffer = "";
            while (OperaLauncherBinary.this.running.get()) {
                try {
                    int r = stream.read();
                    if (r == -1) {
                        return;
                    }
                    if (r == 10) {
                        Level level = Level.FINE;
                        Matcher matcher = pattern.matcher(buffer);
                        if (matcher.find()) {
                            level = OperaLauncherRunner.toLauncherLoggingLevel(Level.parse(matcher.group(1)));
                            buffer = "launcher: " + buffer.replaceFirst(OperaLauncherBinary.launcherLoggingOutputExpression, "").trim();
                        } else {
                            buffer = "opera: " + buffer;
                        }
                        OperaLauncherBinary.this.logger.log(level, buffer);
                        buffer = "";
                        continue;
                    }
                    buffer = buffer + (char)r;
                }
                catch (IOException e) {}
            }
        }

        public void kill() {
            OperaLauncherBinary.this.running.set(false);
            try {
                ProcessUtils.killProcess((Process)this.process);
            }
            catch (Exception e) {
                OperaLauncherBinary.this.logger.warning("Could not kill the process: " + e.getMessage());
            }
        }
    }
}

