/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.model.ICommand;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.util.VersionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.Pointer;
import org.openqa.selenium.WebDriverException;

public abstract class AbstractService {
    protected ScopeServices services;
    private static final Logger logger = Logger.getLogger(AbstractService.class.getName());
    private final String version;

    public String getVersion() {
        return this.version;
    }

    public AbstractService(ScopeServices services, String version) {
        this.services = services;
        this.version = version;
    }

    public static void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isVersionInRange(String version, String maxVersion, String serviceName) {
        return VersionUtil.compare(version, maxVersion) < 0 && VersionUtil.compare(version, this.services.getMinVersionFor(serviceName)) >= 0;
    }

    public UmsProtos.Response executeCommand(ICommand command, AbstractMessage.Builder<?> builder) {
        if (this.services.getConnection() == null) {
            return UmsProtos.Response.getDefaultInstance();
        }
        return this.executeCommand(command, builder, OperaIntervals.DEFAULT_RESPONSE_TIMEOUT.getValue());
    }

    public UmsProtos.Response executeCommand(ICommand command, AbstractMessage.Builder<?> builder, long timeout) {
        if (this.services.getConnection() == null) {
            return UmsProtos.Response.getDefaultInstance();
        }
        return this.services.executeCommand(command, builder, timeout);
    }

    public Object xpathQuery(Collection<?> collection, String query) {
        JXPathContext pathContext = JXPathContext.newContext(collection);
        Object result = null;
        try {
            result = pathContext.getValue(query);
        }
        catch (JXPathNotFoundException e) {
            logger.log(Level.WARNING, "JXPath exception: {0}", e.getMessage());
        }
        return result;
    }

    public Pointer xpathPointer(Collection<?> collection, String query) {
        JXPathContext pathContext = JXPathContext.newContext(collection);
        Pointer result = null;
        try {
            result = pathContext.getPointer(query);
        }
        catch (JXPathNotFoundException e) {
            logger.log(Level.WARNING, "JXPath exception: {0}", e.getMessage());
        }
        return result;
    }

    public Iterator<?> xpathIterator(Collection<?> collection, String query) {
        JXPathContext pathContext = JXPathContext.newContext(collection);
        Iterator result = null;
        try {
            result = pathContext.iteratePointers(query);
        }
        catch (JXPathNotFoundException e) {
            logger.log(Level.WARNING, "JXPath exception: {0}", e.getMessage());
        }
        return result;
    }

    public static final GeneratedMessage.Builder<?> buildPayload(UmsProtos.Response response, GeneratedMessage.Builder<?> builder) {
        return AbstractService.buildMessage(builder, response.getPayload().toByteArray());
    }

    private static final GeneratedMessage.Builder<?> buildMessage(GeneratedMessage.Builder<?> builder, byte[] message) {
        try {
            return (GeneratedMessage.Builder)builder.mergeFrom(message);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new WebDriverException("Could not build " + builder.getDescriptorForType().getFullName() + ": " + ex.getMessage());
        }
    }
}

