/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CoreUtilsCommand implements ICommand
{
    ONACTIVE(1),
    ONIDLE(2),
    GET_BROWSER_INFORMATION(3),
    CLEAR_PRIVATE_DATA(4),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, CoreUtilsCommand> lookup;

    private CoreUtilsCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "core";
    }

    public static CoreUtilsCommand get(int code) {
        CoreUtilsCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, CoreUtilsCommand>();
        for (CoreUtilsCommand command : EnumSet.allOf(CoreUtilsCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

