/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DesktopWindowManagerCommand implements ICommand
{
    GET_ACTIVE_WINDOW(1),
    LIST_WINDOWS(2),
    LIST_QUICK_WIDGETS(3),
    GET_QUICK_WIDGET(4),
    WINDOW_SHOWN(5),
    WINDOW_UPDATED(6),
    WINDOW_CLOSED(7),
    WINDOW_ACTIVATED(8),
    WINDOW_LOADED(9),
    LIST_QUICK_MENUS(10),
    MENU_SHOWN(11),
    MENU_CLOSED(12),
    PRESS_QUICK_MENU(13),
    MENU_PRESSED(14),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, DesktopWindowManagerCommand> lookup;

    private DesktopWindowManagerCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "desktop-window-manager";
    }

    public static DesktopWindowManagerCommand get(int code) {
        DesktopWindowManagerCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, DesktopWindowManagerCommand>();
        for (DesktopWindowManagerCommand command : EnumSet.allOf(DesktopWindowManagerCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

