/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.opera.core.systems.model.ICommand;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ScopeCommand implements ICommand
{
    CONNECT(3),
    DISCONNECT(4),
    ENABLE(5),
    DISABLE(6),
    INFO(7),
    QUIT(8),
    HOST_INFO(10),
    MESSAGE_INFO(11),
    DEFAULT(-1);

    private int code;
    private static final Map<Integer, ScopeCommand> lookup;

    private ScopeCommand(int code) {
        this.code = code;
    }

    @Override
    public int getCommandID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "scope";
    }

    public static ScopeCommand get(int code) {
        ScopeCommand command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = new HashMap<Integer, ScopeCommand>();
        for (ScopeCommand command : EnumSet.allOf(ScopeCommand.class)) {
            lookup.put(command.getCommandID(), command);
        }
    }
}

