/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.handlers;

import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.handlers.EventHandler;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.WmProtos;

public class ScopeEventHandler
implements EventHandler {
    protected ScopeServices services;

    public ScopeEventHandler(ScopeServices services) {
        this.services = services;
    }

    @Override
    public void onRuntimeStopped(Integer id) {
        this.services.getDebugger().removeRuntime(id);
    }

    @Override
    public void onRequest(int windowId) {
        this.services.onRequest(windowId);
    }

    @Override
    public void onWindowActivated(Integer id) {
        this.services.getWindowManager().setActiveWindowId(id);
    }

    @Override
    public void onWindowClosed(Integer id) {
        this.services.onWindowClosed(id);
        this.services.getWindowManager().removeWindow(id);
        this.services.getDebugger().cleanUpRuntimes(id);
    }

    @Override
    public void onWindowLoaded(int windowId) {
        this.services.getDebugger().cleanUpRuntimes(windowId);
        this.services.onWindowLoaded(windowId);
    }

    @Override
    public void onOperaIdle() {
        this.services.onOperaIdle();
    }

    @Override
    public void onRuntimeStarted(EsdbgProtos.RuntimeInfo info) {
        this.services.getDebugger().addRuntime(info);
    }

    @Override
    public void onWindowUpdated(WmProtos.WindowInfo info) {
        this.services.getWindowManager().addWindow(info);
    }

    @Override
    public void onMessage(ConsoleLoggerProtos.ConsoleMessage message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onHttpResponse(int responseCode) {
        this.services.getWindowManager().getLastHttpResponseCode().compareAndSet(0, responseCode);
    }

    @Override
    public void onReadyStateChange(EcmascriptProtos.ReadyStateChange change) {
        this.services.getDebugger().readyStateChanged(change);
    }

    @Override
    public void onDesktopWindowShown(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowShown(info);
    }

    @Override
    public void onDesktopWindowUpdated(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowUpdated(info);
    }

    @Override
    public void onDesktopWindowActivated(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowActivated(info);
    }

    @Override
    public void onDesktopWindowClosed(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowClosed(info);
    }

    @Override
    public void onDesktopWindowLoaded(DesktopWmProtos.DesktopWindowInfo info) {
        this.services.onDesktopWindowLoaded(info);
    }

    @Override
    public void onQuickMenuShown(DesktopWmProtos.QuickMenuInfo menuInfoShown) {
        this.services.onQuickMenuShown(menuInfoShown);
    }

    @Override
    public void onQuickMenuClosed(DesktopWmProtos.QuickMenuID menuId) {
        this.services.onQuickMenuClosed(menuId);
    }

    @Override
    public void onQuickMenuItemPressed(DesktopWmProtos.QuickMenuItemID menuItemID) {
        this.services.onQuickMenuItemPressed(menuItemID);
    }

    @Override
    public void onSelftestOutput(SelftestProtos.SelftestOutput output) {
        this.services.onSelftestOutput(output);
    }

    @Override
    public void onSelftestDone() {
        this.services.onSelftestDone();
    }
}

