/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.CookieManagerCommand;
import com.opera.core.systems.scope.protos.CookieMngProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ICookieManager;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Cookie;

public class CookieManager
extends AbstractService
implements ICookieManager {
    private int maxCookies;
    private int maxCookiesPerDomain;
    private int maxCookieLength;

    @Override
    public int getMaxCookies() {
        return this.maxCookies;
    }

    @Override
    public int getMaxCookiesPerDomain() {
        return this.maxCookiesPerDomain;
    }

    @Override
    public int getMaxCookieLength() {
        return this.maxCookieLength;
    }

    public CookieManager(ScopeServices services, String version) {
        super(services, version);
        services.setCookieManager(this);
    }

    @Override
    public void init() {
        CookieMngProtos.CookieSettings settings = this.getCookieSettings();
        this.maxCookies = settings.getMaxCookies();
        this.maxCookiesPerDomain = settings.getMaxCookiesPerDomain();
        this.maxCookieLength = settings.getMaxCookieLength();
    }

    @Override
    public Set<Cookie> getCookie(String domain, String path) {
        if (domain == null) {
            throw new NullPointerException("Domain can not be null");
        }
        CookieMngProtos.GetCookieArg.Builder arg = CookieMngProtos.GetCookieArg.newBuilder();
        arg.setDomain(domain);
        if (path != null) {
            arg.setPath(path);
        }
        UmsProtos.Response response = this.executeCommand(CookieManagerCommand.GET_COOKIE, (AbstractMessage.Builder<?>)arg);
        CookieMngProtos.CookieList.Builder builder = CookieMngProtos.CookieList.newBuilder();
        CookieManager.buildPayload(response, builder);
        CookieMngProtos.CookieList list = builder.build();
        List<CookieMngProtos.Cookie> cookies = list.getCookieListList();
        HashSet<Cookie> result = new HashSet<Cookie>(cookies.size());
        for (CookieMngProtos.Cookie cookie : cookies) {
            result.add(new Cookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), new Date(cookie.getExpires()), cookie.getIsSecure()));
        }
        return result;
    }

    @Override
    public void removeCookie(String domain, String path, String name) {
        if (domain == null) {
            throw new NullPointerException("Domain can not be null");
        }
        CookieMngProtos.RemoveCookieArg.Builder arg = CookieMngProtos.RemoveCookieArg.newBuilder();
        arg.setDomain(domain);
        if (path != null) {
            arg.setPath(path);
        }
        if (name != null) {
            arg.setName(name);
        }
        this.executeCommand(CookieManagerCommand.REMOVE_COOKIE, (AbstractMessage.Builder<?>)arg);
    }

    @Override
    public void removeAllCookies() {
        this.executeCommand(CookieManagerCommand.REMOVE_ALL_COOKIES, null);
    }

    private CookieMngProtos.CookieSettings getCookieSettings() {
        UmsProtos.Response response = this.executeCommand(CookieManagerCommand.GET_COOKIE_SETTINGS, null);
        CookieMngProtos.CookieSettings.Builder builder = CookieMngProtos.CookieSettings.newBuilder();
        CookieManager.buildPayload(response, builder);
        return builder.build();
    }
}

