/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.handlers.EventHandler;
import com.opera.core.systems.scope.handlers.IConnectionHandler;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.stp.UmsEventParser;
import com.opera.core.systems.util.SocketListener;
import com.opera.core.systems.util.SocketMonitor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;

public class StpConnection
implements SocketListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private SocketChannel socketChannel;
    private final ArrayBlockingQueue<ByteBuffer> requests;
    private ByteBuffer recvBuffer;
    final byte[] prefix = new byte[]{83, 84, 80, 1};
    private ByteString stpPrefix = ByteString.copyFrom((byte[])this.prefix);
    private EventHandler eventHandler;
    private UmsEventParser stp1EventHandler;
    private IConnectionHandler connectionHandler;
    private State state = State.SERVICELIST;
    private SocketMonitor monitor;

    private void setState(State state) {
        this.state = state;
    }

    public boolean isConnected() {
        return this.socketChannel != null;
    }

    public StpConnection(SocketChannel socket, IConnectionHandler handler, EventHandler eventHandler, SocketMonitor monitor) throws IOException {
        this.connectionHandler = handler;
        this.socketChannel = socket;
        this.eventHandler = eventHandler;
        this.monitor = monitor;
        this.requests = new ArrayBlockingQueue(1024);
        this.recvBuffer = ByteBuffer.allocateDirect(65536);
        this.recvBuffer.limit(0);
        socket.configureBlocking(false);
        monitor.add(socket, this, 1);
        if (!handler.onConnected(this)) {
            this.close();
            throw new IOException("Connection not allowed from IConnectionHandler (already connected)");
        }
    }

    private void switchToStp1() {
        this.stp1EventHandler = new UmsEventParser(this.eventHandler);
        this.sendEnableStp1();
        this.setState(State.HANDSHAKE);
    }

    public void send(UmsProtos.Command command) {
        this.logger.finest(command.toString());
        byte[] payload = command.toByteArray();
        int totalSize = payload.length + 1;
        ByteBuffer outMessageSize = this.encodeMessageSize(totalSize);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.prefix.length + outMessageSize.position() + 1 + payload.length);
        buffer.put(this.prefix, 0, this.prefix.length);
        outMessageSize.flip();
        buffer.put(outMessageSize);
        buffer.put((byte)1);
        buffer.put(payload);
        this.logger.finest("SEND: " + command.toString());
        this.requests.add(buffer);
        this.monitor.modify(this.socketChannel, this, 5);
    }

    public void sendEnableStp1() {
        this.send("*enable stp-1");
    }

    public void sendQuit() {
        this.send("*quit");
    }

    private void send(String message) {
        String scopeMessage = message.length() + " " + message;
        this.logger.finest("WRITE : " + scopeMessage);
        byte[] bytes = null;
        try {
            bytes = scopeMessage.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            this.close();
            this.connectionHandler.onException(e);
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        this.requests.add(buffer);
        this.monitor.modify(this.socketChannel, this, 5);
    }

    @Override
    public boolean canRead(SelectableChannel channel) throws IOException {
        this.logger.finest("canRead");
        if (!channel.isOpen()) {
            return false;
        }
        if (this.socketChannel == null) {
            throw new IOException("We dont have a socket :-)");
        }
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(1000);
        int readSize = 0;
        boolean didNotFindAnyMessage = false;
        while (!didNotFindAnyMessage) {
            this.logger.finest("canReadLoop!");
            do {
                readBuffer.clear();
                try {
                    if (this.socketChannel == null) {
                        readSize = -1;
                    } else {
                        readSize = this.socketChannel.read(readBuffer);
                        if (readSize > 0) {
                            readBuffer.limit(readSize);
                            readBuffer.position(0);
                        }
                    }
                }
                catch (IOException ex) {
                    this.logger.warning("Channel closed, causing exception: " + ex.getMessage());
                    readSize = -1;
                }
                if (readSize < 0) {
                    try {
                        this.logger.log(Level.FINER, "Channel closed: {0}", this.socketChannel.socket().getInetAddress().getHostName());
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    this.connectionHandler.onDisconnect();
                    this.monitor.remove(this.socketChannel);
                    return false;
                }
                if (readSize <= 0) continue;
                if (this.recvBuffer.limit() + readBuffer.limit() >= this.recvBuffer.capacity()) {
                    this.logger.finest("Doubled the size of our recv buffer!");
                    ByteBuffer newRecvBuffer = ByteBuffer.allocate(this.recvBuffer.capacity() * 2);
                    newRecvBuffer.clear();
                    this.recvBuffer.position(0);
                    newRecvBuffer.limit(this.recvBuffer.limit());
                    newRecvBuffer.position(0);
                    newRecvBuffer.put(this.recvBuffer);
                    newRecvBuffer.position(0);
                    this.recvBuffer = newRecvBuffer;
                }
                this.recvBuffer.position(this.recvBuffer.limit());
                this.recvBuffer.limit(this.recvBuffer.limit() + readSize);
                this.recvBuffer.put(readBuffer);
                this.logger.finest("did read " + readSize + " bytes, new buffer size = " + this.recvBuffer.limit());
            } while (readSize > 0);
            didNotFindAnyMessage = true;
            while (this.readMessage(this.recvBuffer)) {
                didNotFindAnyMessage = false;
            }
        }
        return true;
    }

    @Override
    public boolean canWrite(SelectableChannel channel) throws IOException {
        this.logger.finest("canWrite");
        if (this.socketChannel == null) {
            throw new IOException("We don't have a socket :-)");
        }
        int totalWritten = 0;
        block0: while (!this.requests.isEmpty()) {
            ByteBuffer buffer = this.requests.poll();
            buffer.flip();
            int written = 0;
            while ((written = this.socketChannel.write(buffer)) > 0) {
                if (written > 0) {
                    totalWritten += written;
                }
                if (buffer.hasRemaining()) continue;
                continue block0;
            }
        }
        this.logger.finest("Wrote " + totalWritten + " bytes");
        return !this.requests.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socketChannel == null) {
            return;
        }
        this.monitor.remove(this.socketChannel);
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socketChannel = null;
        }
    }

    public void parseServiceList(String message) {
        this.logger.finer("parseServiceList: \"" + message + "\"");
        int split = message.indexOf(" ");
        if (split < 0) {
            this.connectionHandler.onException((Exception)((Object)new WebDriverException("Invalid service list received.")));
            return;
        }
        List<String> services = Arrays.asList(message.substring(split + 1).split(","));
        this.connectionHandler.onServiceList(services);
        this.logger.fine("Service list ok");
        if (!services.contains("stp-1")) {
            this.connectionHandler.onException((Exception)((Object)new WebDriverException("STP/0 is not supported!")));
            return;
        }
        this.switchToStp1();
    }

    private void signalResponse(int tag, UmsProtos.Response response) {
        this.connectionHandler.onResponseReceived(tag, response);
    }

    private void signalEvent(UmsProtos.Event event) {
        this.logger.finest("EVENT " + event.toString());
        this.stp1EventHandler.handleEvent(event);
    }

    private boolean readMessage(ByteBuffer buffer) {
        buffer.position(0);
        int bytesWeHaveBeenreading = 0;
        switch (this.state) {
            case SERVICELIST: {
                StringBuilder builder = new StringBuilder();
                builder.append(buffer.asCharBuffer());
                this.parseServiceList(builder.toString());
                buffer.position(0);
                bytesWeHaveBeenreading = buffer.limit();
                break;
            }
            case HANDSHAKE: {
                if (buffer.limit() < 6) break;
                byte[] dst = new byte[6];
                buffer.position(0);
                buffer.get(dst);
                buffer.position(0);
                bytesWeHaveBeenreading = 6;
                String handShake = new String(dst);
                if (!handShake.equals("STP/1\n")) {
                    this.close();
                    this.connectionHandler.onException((Exception)((Object)new WebDriverException("Scope Transport Protocol Error : Handshake")));
                    break;
                }
                this.setState(State.EMPTY);
                this.connectionHandler.onHandshake(true);
                break;
            }
            case EMPTY: {
                if (buffer.limit() < 4) break;
                byte[] headerPrefix = new byte[4];
                buffer.get(headerPrefix);
                buffer.position(0);
                bytesWeHaveBeenreading = 4;
                ByteString incomingPrefix = ByteString.copyFrom((byte[])headerPrefix);
                if (this.stpPrefix.equals((Object)incomingPrefix)) {
                    this.setState(State.STP);
                    break;
                }
                this.close();
                this.connectionHandler.onException((Exception)((Object)new WebDriverException("Scope Transport Protocol Error : Header")));
                break;
            }
            case STP: {
                buffer.position(0);
                if (buffer.limit() <= 0) {
                    this.logger.finest("STP: Empty buffer");
                    break;
                }
                int messageSize = this.readRawVarint32(buffer);
                bytesWeHaveBeenreading = buffer.position();
                buffer.position(0);
                if (buffer.limit() >= bytesWeHaveBeenreading + messageSize) {
                    buffer.position(bytesWeHaveBeenreading);
                    byte messageType = buffer.get();
                    ++bytesWeHaveBeenreading;
                    byte[] payload = new byte[--messageSize];
                    buffer.get(payload);
                    buffer.position(0);
                    bytesWeHaveBeenreading += messageSize;
                    this.setState(State.EMPTY);
                    try {
                        this.processMessage(messageType, payload);
                    }
                    catch (IOException e) {
                        this.close();
                        this.connectionHandler.onException((Exception)((Object)new WebDriverException("Error while processing the message: " + e.getMessage())));
                    }
                    break;
                }
                this.logger.finest("tried to read a message, but expected " + (4 + messageSize) + " bytes, and only got " + buffer.limit());
                buffer.position(0);
                bytesWeHaveBeenreading = 0;
            }
        }
        if (bytesWeHaveBeenreading > 0) {
            int rest = buffer.limit() - bytesWeHaveBeenreading;
            if (rest <= 0) {
                buffer.clear();
                buffer.limit(0);
            } else {
                byte[] temp = new byte[rest];
                buffer.position(bytesWeHaveBeenreading);
                buffer.get(temp, 0, rest);
                buffer.clear();
                buffer.limit(rest);
                buffer.position(0);
                buffer.put(temp, 0, rest);
                buffer.position(0);
            }
            this.logger.finest("Did read message of " + bytesWeHaveBeenreading + " bytes, new buffer size = " + buffer.limit());
            return true;
        }
        if (buffer.limit() > 0) {
            this.logger.finest("did NOT read message from buffer of size = " + buffer.limit());
        } else {
            this.logger.finest("no messages in empty buffer");
        }
        return false;
    }

    private void processMessage(int stpType, byte[] payload) throws IOException {
        this.logger.finest("processMessage: " + stpType);
        switch (stpType) {
            case 2: {
                UmsProtos.Response response = UmsProtos.Response.parseFrom(payload);
                this.logger.finest("RECV RESPONSE: " + response.toString());
                this.signalResponse(response.getTag(), response);
                break;
            }
            case 3: {
                UmsProtos.Event event = UmsProtos.Event.parseFrom(payload);
                this.logger.finest("RECV EVENT: " + event.toString());
                this.signalEvent(event);
                break;
            }
            case 4: {
                UmsProtos.Error error = UmsProtos.Error.parseFrom(payload);
                this.logger.finest("RECV ERROR: " + error.toString());
                String service = error.getService();
                int status = error.getStatus();
                if (service.equals("ecmascript-debugger") && status == UmsProtos.Status.INTERNAL_ERROR.getNumber() || service.equals("ecmascript") && status == UmsProtos.Status.BAD_REQUEST.getNumber()) {
                    this.signalResponse(error.getTag(), null);
                    break;
                }
                this.connectionHandler.onException((Exception)((Object)new CommunicationException(String.format("Error on command: %s", error))));
                break;
            }
            default: {
                this.connectionHandler.onException((Exception)((Object)new CommunicationException(String.format("Unhandled STP type: %d" + stpType, new Object[0]))));
            }
        }
    }

    private int readRawVarint32(ByteBuffer bytes) {
        byte tmp = bytes.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = bytes.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = bytes.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = bytes.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = bytes.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (bytes.get() < 0) continue;
                            return result;
                        }
                        this.connectionHandler.onException((Exception)((Object)new WebDriverException("Error while reading raw int")));
                    }
                }
            }
        }
        return result;
    }

    private ByteBuffer encodeMessageSize(int value) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(CodedOutputStream.computeRawVarint32Size((int)value));
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buffer.put((byte)value);
                return buffer;
            }
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static enum State {
        SERVICELIST,
        HANDSHAKE,
        EMPTY,
        STP;

    }
}

