/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.testing.drivers;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaProduct;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.scope.services.IOperaExec;
import com.opera.core.systems.scope.services.IWindowManager;
import org.openqa.selenium.Capabilities;

public class TestOperaDriver
extends OperaDriver {
    private final IWindowManager windowManager = this.getScopeServices().getWindowManager();
    private OperaProduct currentProduct = null;

    public TestOperaDriver(Capabilities capabilities) {
        this(new OperaSettings().merge(capabilities));
    }

    public TestOperaDriver(OperaSettings settings) {
        super(settings);
    }

    public OperaRunner getRunner() {
        return this.runner;
    }

    public OperaSettings getSettings() {
        return this.settings;
    }

    @Override
    public Capabilities getCapabilities() {
        return this.settings.toCapabilities();
    }

    public ScopeServices getServices() {
        return this.getScopeServices();
    }

    @Override
    public IOperaExec getExecService() {
        return super.getExecService();
    }

    public boolean isRunning() {
        return this.runner != null ? this.runner.isOperaRunning() : this.getScopeServices().isConnected();
    }

    public void createWindow() {
        this.windowManager.createWindow();
    }

    public void closeAll() {
        if (!this.isRunning()) {
            return;
        }
        this.windowManager.closeAllWindows();
        if (this.utils().getProduct().is(OperaProduct.DESKTOP)) {
            this.windowManager.createWindow();
        }
        this.switchTo().defaultContent();
    }

    @Override
    public TestOperaUtils utils() {
        return new TestOperaUtils();
    }

    public class TestOperaUtils
    extends OperaDriver.OperaUtils {
        @Override
        public OperaProduct getProduct() {
            if (TestOperaDriver.this.currentProduct == null) {
                TestOperaDriver.this.currentProduct = OperaProduct.CORE;
                String requestedProduct = System.getenv("OPERA_PRODUCT");
                if (requestedProduct == null || requestedProduct.isEmpty()) {
                    requestedProduct = super.getProduct().toString();
                } else {
                    TestOperaDriver.this.logger.warning("Driver is not running, defaulting to " + (Object)((Object)TestOperaDriver.this.currentProduct));
                }
                try {
                    TestOperaDriver.this.currentProduct = OperaProduct.get(requestedProduct);
                }
                catch (IllegalArgumentException e) {
                    TestOperaDriver.this.logger.warning(String.format("Product `%s' not found, defaulting to %s", new Object[]{requestedProduct, TestOperaDriver.this.currentProduct}));
                }
            }
            return TestOperaDriver.this.currentProduct;
        }
    }

    public static enum ClosingStrategy {
        SWITCH_TO,
        ACTION;

    }
}

