/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IParameterizable;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.internal.ArrayIterator;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderHolder;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    public static final String NULL_VALUE = "null";

    public static Object[] createInstantiationParameters(Constructor ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, finder, parameterNames, new MethodParameters(params), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, Object[] parameterValues, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx, ITestResult testResult) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        return Parameters.createParameters(m, new MethodParameters(params, parameterValues, currentTestMeth, ctx, testResult), finder, xmlSuite, IConfigurationAnnotation.class, "@Configuration");
    }

    public static Object getInjectedParameter(Class<?> c, Method method, ITestContext context, ITestResult testResult) {
        Object result = null;
        if (Method.class.equals(c)) {
            result = method;
        } else if (ITestContext.class.equals(c)) {
            result = context;
        } else if (XmlTest.class.equals(c)) {
            result = context.getCurrentXmlTest();
        } else if (ITestResult.class.equals(c)) {
            result = testResult;
        }
        return result;
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String[] optionalValues, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            List vResult = Lists.newArrayList();
            Parameters.checkParameterTypes(methodName, parameterTypes, methodAnnotation, parameterNames);
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object inject = Parameters.getInjectedParameter(parameterTypes[i], params.currentTestMethod, params.context, params.testResult);
                if (inject != null) {
                    vResult.add(inject);
                    continue;
                }
                if (j >= parameterNames.length) continue;
                String p = parameterNames[j];
                String value = (String)params.xmlParameters.get(p);
                if (null == value) {
                    value = System.getProperty(p);
                }
                if (null == value) {
                    if (optionalValues != null) {
                        value = optionalValues[i];
                    }
                    if (null == value) {
                        throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on method " + methodName + "\nbut has not been marked @Optional or defined " + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                    }
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static void checkParameterTypes(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        int totalLength = parameterTypes.length;
        HashSet<Class> injectedTypes = new HashSet<Class>(){
            private static final long serialVersionUID = -5324894581793435812L;
            {
                this.add(ITestContext.class);
                this.add(ITestResult.class);
                this.add(XmlTest.class);
                this.add(Method.class);
                this.add(Object[].class);
            }
        };
        for (Class parameterType : parameterTypes) {
            if (!injectedTypes.contains(parameterType)) continue;
            --totalLength;
        }
        if (parameterNames.length != totalLength) {
            throw new TestNGException("Method " + methodName + " requires " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
        }
    }

    public static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
            }
            return null;
        }
        if (type == String.class) {
            result = value;
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = Integer.parseInt(value);
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = Boolean.valueOf(value);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = Byte.parseByte(value);
        } else if (type == Character.TYPE || type == Character.class) {
            result = Character.valueOf(value.charAt(0));
        } else if (type == Double.TYPE || type == Double.class) {
            result = Double.parseDouble(value);
        } else if (type == Float.TYPE || type == Float.class) {
            result = Float.valueOf(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == Long.class) {
            result = Long.parseLong(value);
        } else if (type == Short.TYPE || type == Short.class) {
            result = Short.parseShort(value);
        } else assert (false) : "Unsupported type parameter : " + type;
        return result;
    }

    private static DataProviderHolder findDataProvider(Class clazz, ConstructorOrMethod m, IAnnotationFinder finder) {
        DataProviderHolder result = null;
        IDataProvidable dp = Parameters.findDataProviderInfo(clazz, m, finder);
        if (dp != null) {
            String dataProviderName = dp.getDataProvider();
            Class<?> dataProviderClass = dp.getDataProviderClass();
            if (!Utils.isStringEmpty(dataProviderName) && null == (result = Parameters.findDataProvider(clazz, finder, dataProviderName, dataProviderClass))) {
                throw new TestNGException("Method " + m + " requires a @DataProvider named : " + dataProviderName + (dataProviderClass != null ? " in class " + dataProviderClass.getName() : ""));
            }
        }
        return result;
    }

    private static IDataProvidable findDataProviderInfo(Class clazz, ConstructorOrMethod m, IAnnotationFinder finder) {
        IDataProvidable result = null;
        if (m.getMethod() != null) {
            result = AnnotationHelper.findTest(finder, m.getMethod());
            if (result == null) {
                result = AnnotationHelper.findTest(finder, clazz);
            }
            if (result == null) {
                result = AnnotationHelper.findFactory(finder, m.getMethod());
            }
        } else {
            result = AnnotationHelper.findFactory(finder, m.getConstructor());
        }
        return result;
    }

    private static DataProviderHolder findDataProvider(Class cls, IAnnotationFinder finder, String name, Class dataProviderClass) {
        DataProviderHolder result = null;
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            IDataProviderAnnotation dp = (IDataProviderAnnotation)finder.findAnnotation(m, IDataProviderAnnotation.class);
            if (null == dp || !name.equals(dp.getName()) && !name.equals(m.getName())) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                throw new TestNGException("DataProvider should be static: " + m);
            }
            if (result != null) {
                throw new TestNGException("Found two providers called '" + name + "' on " + cls);
            }
            result = new DataProviderHolder(dp, m);
        }
        return result;
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        List result = Lists.newArrayList();
        Object[] extraParameters = new Object[]{};
        IParametersAnnotation annotation = (IParametersAnnotation)finder.findAnnotation(m, IParametersAnnotation.class);
        Class[] types = m.getParameterTypes();
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a && a.getParameters().length > 0) {
                String[] parameterNames = a.getParameters();
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
            } else {
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, new String[0], params, xmlSuite);
            }
        }
        for (Class type : types) {
            if (!Object[].class.equals((Object)type)) continue;
            result.add(params.parameterValues);
        }
        for (Object p : extraParameters) {
            result.add(p);
        }
        return result.toArray(new Object[result.size()]);
    }

    public static ParameterHolder handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance) {
        ParameterHolder result;
        Iterator<Object[]> parameters = null;
        DataProviderHolder dataProviderHolder = Parameters.findDataProvider(testMethod.getTestClass().getRealClass(), testMethod.getConstructorOrMethod(), annotationFinder);
        if (null != dataProviderHolder) {
            int parameterCount = testMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            parameters = MethodInvocationHelper.invokeDataProvider(instance, dataProviderHolder.method, testMethod, methodParams.context, fedInstance, annotationFinder);
            Iterator<Object[]> filteredParameters = Parameters.filterParameters(parameters, testMethod.getInvocationNumbers());
            result = new ParameterHolder(filteredParameters, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, dataProviderHolder);
        } else {
            allParameterNames.putAll(methodParams.xmlParameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getMethod(), methodParams, annotationFinder, xmlSuite, ITestAnnotation.class, "@Test")};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            parameters = MethodHelper.createArrayIterator(allParameterValuesArray);
            result = new ParameterHolder(parameters, ParameterHolder.ParameterOrigin.ORIGIN_XML, dataProviderHolder);
        }
        return result;
    }

    private static Iterator<Object[]> filterParameters(Iterator<Object[]> parameters, List<Integer> list) {
        if (list.isEmpty()) {
            return parameters;
        }
        List result = Lists.newArrayList();
        int i = 0;
        while (parameters.hasNext()) {
            Object[] next = parameters.next();
            if (list.contains(i)) {
                result.add(next);
            }
            ++i;
        }
        return new ArrayIterator((Object[][])result.toArray((T[])new Object[list.size()][]));
    }

    private static void ppp(String s) {
        System.out.println("[Parameters] " + s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        public ITestResult testResult;

        public MethodParameters(Map<String, String> params) {
            this(params, null, null, null, null);
        }

        public MethodParameters(Map<String, String> params, Method m) {
            this(params, null, m, null, null);
        }

        public MethodParameters(Map<String, String> params, Object[] pv, Method m, ITestContext ctx, ITestResult tr) {
            this.xmlParameters = params;
            this.currentTestMethod = m;
            this.context = ctx;
            this.parameterValues = pv;
            this.testResult = tr;
        }
    }
}

