/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ClassMethodMap;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodWorker
implements IWorker<ITestNGMethod> {
    private IMethodInstance[] m_methodInstances;
    private final IInvoker m_invoker;
    private final Map<String, String> m_parameters;
    private final XmlSuite m_suite;
    private final ITestNGMethod[] m_allTestMethods;
    private List<ITestResult> m_testResults = Lists.newArrayList();
    private final ConfigurationGroupMethods m_groupMethods;
    private final ClassMethodMap m_classMethodMap;
    private final ITestContext m_testContext;

    public TestMethodWorker(IInvoker invoker, IMethodInstance[] testMethods, XmlSuite suite, Map<String, String> parameters, ITestNGMethod[] allTestMethods, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap, ITestContext testContext) {
        this.m_invoker = invoker;
        this.m_methodInstances = testMethods;
        this.m_suite = suite;
        this.m_parameters = parameters;
        this.m_allTestMethods = allTestMethods;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = testContext;
    }

    @Override
    public long getTimeOut() {
        long result = 0L;
        for (IMethodInstance mi : this.m_methodInstances) {
            ITestNGMethod tm = mi.getMethod();
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Worker thread:" + Thread.currentThread().getId() + " priority:" + this.getPriority() + " ");
        result.append(this.m_methodInstances[0].getMethod());
        result.append("]");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (IMethodInstance testMthdInst : this.m_methodInstances) {
            Object var8_7;
            ITestNGMethod testMethod = testMthdInst.getMethod();
            ITestClass testClass = testMethod.getTestClass();
            this.invokeBeforeClassMethods(testClass, testMthdInst);
            try {
                this.invokeTestMethods(testMethod, testMthdInst.getInstances(), this.m_testContext);
                var8_7 = null;
                this.invokeAfterClassMethods(testClass, testMthdInst);
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.invokeAfterClassMethods(testClass, testMthdInst);
                throw throwable;
            }
        }
    }

    protected void invokeTestMethods(ITestNGMethod tm, Object[] instances, ITestContext testContext) {
        List<ITestResult> testResults = this.m_invoker.invokeTestMethods(tm, this.m_allTestMethods, this.indexOf(tm, this.m_allTestMethods), this.m_suite, this.m_parameters, this.m_groupMethods, instances, testContext);
        if (testResults != null) {
            this.m_testResults.addAll(testResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeBeforeClassMethods(ITestClass testClass, IMethodInstance mi) {
        if (null == this.m_classMethodMap || null == this.m_classMethodMap.getInvokedBeforeClassMethods()) {
            return;
        }
        ITestNGMethod[] classMethods = testClass.getBeforeClassMethods();
        if (null == classMethods || classMethods.length == 0) {
            return;
        }
        Map<ITestClass, Set<Object>> invokedBeforeClassMethods = this.m_classMethodMap.getInvokedBeforeClassMethods();
        ITestClass iTestClass = testClass;
        synchronized (iTestClass) {
            Set<Object> instances = invokedBeforeClassMethods.get(testClass);
            if (null == instances) {
                instances = new HashSet<Object>();
                invokedBeforeClassMethods.put(testClass, instances);
            }
            for (Object instance : mi.getInstances()) {
                if (instances.contains(instance)) continue;
                instances.add(instance);
                this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null, instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeAfterClassMethods(ITestClass testClass, IMethodInstance mi) {
        if (null == this.m_classMethodMap || null == this.m_classMethodMap.getInvokedAfterClassMethods()) {
            return;
        }
        ITestNGMethod[] afterClassMethods = testClass.getAfterClassMethods();
        if (null == afterClassMethods || afterClassMethods.length == 0) {
            return;
        }
        List invokeInstances = Lists.newArrayList();
        ITestNGMethod tm = mi.getMethod();
        if (this.m_classMethodMap.removeAndCheckIfLast(tm, mi.getInstances()[0])) {
            Map<ITestClass, Set<Object>> invokedAfterClassMethods;
            Map<ITestClass, Set<Object>> map = invokedAfterClassMethods = this.m_classMethodMap.getInvokedAfterClassMethods();
            synchronized (map) {
                Set<Object> instances = invokedAfterClassMethods.get(testClass);
                if (null == instances) {
                    instances = new HashSet<Object>();
                    invokedAfterClassMethods.put(testClass, instances);
                }
                for (Object inst : mi.getInstances()) {
                    if (instances.contains(inst)) continue;
                    invokeInstances.add(inst);
                }
            }
            for (Object inst : invokeInstances) {
                this.m_invoker.invokeConfigurations(testClass, afterClassMethods, this.m_suite, this.m_parameters, null, inst);
            }
        }
    }

    protected int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    private void ppp(String s) {
        Utils.log("TestMethodWorker", 2, ThreadUtil.currentThreadInfo() + ":" + s);
    }

    @Override
    public List<ITestNGMethod> getTasks() {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (IMethodInstance m : this.m_methodInstances) {
            result.add(m.getMethod());
        }
        return result;
    }

    @Override
    public int compareTo(IWorker<ITestNGMethod> other) {
        return this.getPriority() - other.getPriority();
    }

    @Override
    public int getPriority() {
        return this.m_methodInstances.length == 1 ? this.m_methodInstances[0].getMethod().getPriority() : 0;
    }
}

