package com.selenium;

import com.wavemaker.runtime.javaservice.JavaServiceSuperClass;
import com.wavemaker.runtime.service.annotations.ExposeToClient;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.openqa.selenium.support.ui.ExpectedConditions;


@ExposeToClient
public class SeleniumTest extends JavaServiceSuperClass {
   
    public SeleniumTest() {
       super(INFO);
    }

    public void createEntries(int numberToCreate) {
        
        WebDriver driver = new FirefoxDriver();
        WebDriverWait wait = new WebDriverWait(driver, 20);
           
        driver.get("http://localhost:8094/Selenium_Integration_01/");
        
        for(int i=0; i<numberToCreate; i++)
        {
            // click the textBox and enter text for item
            WebElement textBoxItem = wait.until(ExpectedConditions.elementToBeClickable(By.xpath("//input")));
            // alternative
            //WebElement textBoxItem = wait.until(ExpectedConditions.elementToBeClickable(By.xpath("/html/body/div/div/div/div[2]/div[2]/div[3]/div/div/div[2]/div/input")));
            textBoxItem.click();
            textBoxItem.sendKeys("awesomeItem " + i);
            
            // click the textBox and enter text for amount
            WebElement textBoxAmount = wait.until(ExpectedConditions.elementToBeClickable(By.xpath("/html/body/div/div/div/div[2]/div[2]/div[3]/div/div[2]/div[2]/div/input")));
            textBoxAmount.click();
            textBoxAmount.sendKeys("some");
             
            // click button "Add Item"
            WebElement buttonAddItem = wait.until(ExpectedConditions.elementToBeClickable(By.id("main_buttonAddItem")));
            buttonAddItem.click();
        } 
    }
    
    public void deleteEntries(int numberToDelete) {
        
        WebDriver driver = new FirefoxDriver();
        WebDriverWait wait = new WebDriverWait(driver, 20);
           
        driver.get("http://localhost:8094/Selenium_Integration_01/");
        
        try {
            
            for(int j=0; j<numberToDelete; j++) {
	        	
		        // Select first dojoGrid column
		        WebElement dojoColumnFirst = wait.until(ExpectedConditions.elementToBeClickable(By.xpath("//td")));
		        dojoColumnFirst.click();
		        
		        // Click button Remove Item
		        WebElement buttonRemove = wait.until(ExpectedConditions.elementToBeClickable(By.id("main_buttonRemoveItem")));
		        buttonRemove.click();
		        
	        }
	        
        } catch (Exception e) {
			log(ERROR, "Error in deleteEntries: " + e);
		  }
    }
}
