/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import java.text.AttributedString;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class SimplePdfTextRenderer
extends AbstractPdfTextRenderer {
    public static SimplePdfTextRenderer getInstance() {
        return new SimplePdfTextRenderer(DefaultJasperReportsContext.getInstance(), JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
    }

    public SimplePdfTextRenderer(boolean ignoreMissingFont) {
        this(DefaultJasperReportsContext.getInstance(), ignoreMissingFont);
    }

    public SimplePdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        super(jasperReportsContext, ignoreMissingFont);
    }

    protected Phrase getPhrase(JRStyledText styledText, JRPrintText textElement) {
        String text = styledText.getText();
        AttributedString as = styledText.getAttributedString();
        return this.pdfExporter.getPhrase(as, text, textElement);
    }

    @Override
    public void render() {
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.getPhrase(this.styledText, this.text), (float)(this.x + this.leftPadding), (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - this.text.getLeadingOffset(), (float)(this.x + this.width - this.rightPadding), (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.height + this.bottomPadding), 0.0f, this.horizontalAlignment == 8 ? 3 : this.horizontalAlignment);
        colText.setLeading(0.0f, this.text.getLineSpacingFactor());
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public void draw() {
    }
}

