/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JasperRunManager {
    private JasperReportsContext jasperReportsContext;

    private JasperRunManager(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JasperRunManager getDefaultInstance() {
        return new JasperRunManager(DefaultJasperReportsContext.getInstance());
    }

    public static JasperRunManager getInstance(JasperReportsContext jasperReportsContext) {
        return new JasperRunManager(jasperReportsContext);
    }

    public String runToPdfFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public String runToPdfFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void runToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, conn);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
    }

    public void runToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
    }

    public void runToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters, conn);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfStream(jasperPrint, outputStream);
    }

    public void runToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfStream(jasperPrint, outputStream);
    }

    public byte[] runToPdf(String sourceFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, conn);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(String sourceFileName, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(InputStream inputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters, conn);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, conn);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public String runToPdfFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void runToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, jrDataSource);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfFile(jasperPrint, destFileName);
    }

    public void runToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters, jrDataSource);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToPdfStream(jasperPrint, outputStream);
    }

    public byte[] runToPdf(String sourceFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, jrDataSource);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(InputStream inputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(inputStream, parameters, jrDataSource);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public byte[] runToPdf(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, jrDataSource);
        return JasperExportManager.getInstance(this.jasperReportsContext).exportToPdf(jasperPrint);
    }

    public String runToHtmlFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public String runToHtmlFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void runToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, conn);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
    }

    public void runToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
    }

    public String runToHtmlFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        Map<String, Object> parameters = jasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = jasperFillManager.fill(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public void runToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperFillManager jasperFillManager = JasperFillManager.getInstance(this.jasperReportsContext);
        JasperPrint jasperPrint = jasperFillManager.fill(sourceFileName, parameters, jrDataSource);
        JasperExportManager.getInstance(this.jasperReportsContext).exportToHtmlFile(jasperPrint, destFileName);
    }

    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, params, conn);
    }

    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, params);
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, destFileName, parameters, conn);
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, destFileName, parameters);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfStream(inputStream, outputStream, parameters, conn);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfStream(inputStream, outputStream, parameters);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(sourceFileName, parameters, conn);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(sourceFileName, parameters);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(inputStream, parameters, conn);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(inputStream, parameters);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(jasperReport, parameters, conn);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(jasperReport, parameters);
    }

    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, params, jrDataSource);
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfFile(sourceFileName, destFileName, parameters, jrDataSource);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperRunManager.getDefaultInstance().runToPdfStream(inputStream, outputStream, parameters, jrDataSource);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(sourceFileName, parameters, jrDataSource);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(inputStream, parameters, jrDataSource);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        return JasperRunManager.getDefaultInstance().runToPdf(jasperReport, parameters, jrDataSource);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        return JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, params, conn);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params) throws JRException {
        return JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, params);
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, parameters, conn);
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, destFileName, parameters);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        return JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, params, jrDataSource);
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperRunManager.getDefaultInstance().runToHtmlFile(sourceFileName, destFileName, parameters, jrDataSource);
    }
}

