package com.vcoportal;


import com.wavemaker.runtime.RuntimeAccess;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.net.URL;
import java.io.*;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.JRLoader;


public class ReportGenerator extends com.wavemaker.runtime.javaservice.JavaServiceSuperClass {

    public ReportGenerator() {
       super(INFO);
    }

    // some attributes holding the data
    private String titleText;
    private String subTitle;
    
    // getters & setters
    public String getTitleText() {
    	return this.titleText;
    }
    
    public String getSubTitle() {
    	return this.subTitle;
    }
    
    public void setTitleText(String ttext) {
    	this.titleText = ttext;
    }
    
    public void setSubTitle(String stitle) {
    	this.subTitle = stitle;
    }
    
    // a static method that initializes, stores and returns our data
    public static Collection<ReportGenerator> getData() {
    	
    	Vector<ReportGenerator> theData = new Vector<ReportGenerator>();
    	
    	ReportGenerator myReportGen = new ReportGenerator();
    	myReportGen.setTitleText("Hello World!");
    	myReportGen.setSubTitle("This is a subtitle!");
    	theData.add(myReportGen);
    	
    	return theData;
    }
    
    //
    public String printReport() {
    	
    	String fileName = "report.jasper";
    	String typeDocument = "PDF";
    	URL fileUrl = this.getClass().getResource(fileName);
    	Map<String, Object> parameters = new HashMap<String, Object>();
	 		parameters.put("just", new String("testing"));
    	
    	JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(this.getData());
    	
    	try {
    	JasperReport report = (JasperReport) JRLoader.loadObject(fileUrl);
    	JasperPrint jasperPrint = JasperFillManager.fillReport(report, parameters, ds);
    	
    	String pathWR = RuntimeAccess.getInstance().getSession().getServletContext().getRealPath("/printtemp/");
    	File tempDir = new File(pathWR);
    	String tempFileName = new String();
    	
    		if (typeDocument.equals("PDF")) {
    			File tempFile = File.createTempFile("tempReport", ".pdf", tempDir);
    			tempFile.deleteOnExit();
    			tempFileName = tempFile.getName();
    			
    			JRPdfExporter exporter = new JRPdfExporter();
    			exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
    			exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, tempDir + "/" + tempFileName);
    			
    			exporter.exportReport();
    		}
    		
    	return "printtemp/" + tempFileName;
    	
    	} catch (Exception e) {
    		log(ERROR, "Error in printReport(): " + e);
    		return "";
    	}
    	
    }


}


