/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.sid;

import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.util.Assert;

public class PrincipalSid
implements Sid {
    private String principal;

    public PrincipalSid(String principal) {
        Assert.hasText((String)principal, (String)"Principal required");
        this.principal = principal;
    }

    public PrincipalSid(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"Authentication required");
        Assert.notNull((Object)authentication.getPrincipal(), (String)"Principal required");
        this.principal = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            this.principal = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PrincipalSid)) {
            return false;
        }
        return ((PrincipalSid)object).getPrincipal().equals(this.getPrincipal());
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String toString() {
        return "PrincipalSid[" + this.principal + "]";
    }
}

