/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;

public class LdapShaPasswordEncoder
implements PasswordEncoder {
    private static final int SHA_LENGTH = 20;
    private static final String SSHA_PREFIX = "{SSHA}";
    private static final String SSHA_PREFIX_LC = "{SSHA}".toLowerCase();
    private static final String SHA_PREFIX = "{SHA}";
    private static final String SHA_PREFIX_LC = "{SHA}".toLowerCase();
    private boolean forceLowerCasePrefix;
    static /* synthetic */ Class array$B;

    private byte[] combineHashAndSalt(byte[] hash, byte[] salt) {
        if (salt == null) {
            return hash;
        }
        byte[] hashAndSalt = new byte[hash.length + salt.length];
        System.arraycopy(hash, 0, hashAndSalt, 0, hash.length);
        System.arraycopy(salt, 0, hashAndSalt, hash.length, salt.length);
        return hashAndSalt;
    }

    public String encodePassword(String rawPass, Object salt) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new LdapDataAccessException("No SHA implementation available!", e);
        }
        sha.update(rawPass.getBytes());
        if (salt != null) {
            Assert.isInstanceOf((Class)(array$B == null ? (array$B = LdapShaPasswordEncoder.class$("[B")) : array$B), (Object)salt, (String)"Salt value must be a byte array");
            sha.update((byte[])salt);
        }
        byte[] hash = this.combineHashAndSalt(sha.digest(), (byte[])salt);
        String prefix = salt == null ? (this.forceLowerCasePrefix ? SHA_PREFIX_LC : SHA_PREFIX) : (this.forceLowerCasePrefix ? SSHA_PREFIX_LC : SSHA_PREFIX);
        return prefix + new String(Base64.encodeBase64((byte[])hash));
    }

    private byte[] extractSalt(String encPass) {
        String encPassNoLabel = encPass.substring(6);
        byte[] hashAndSalt = Base64.decodeBase64((byte[])encPassNoLabel.getBytes());
        int saltLength = hashAndSalt.length - 20;
        byte[] salt = new byte[saltLength];
        System.arraycopy(hashAndSalt, 20, salt, 0, saltLength);
        return salt;
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String encPassWithoutPrefix;
        if (encPass.startsWith(SSHA_PREFIX) || encPass.startsWith(SSHA_PREFIX_LC)) {
            encPassWithoutPrefix = encPass.substring(6);
            salt = this.extractSalt(encPass);
        } else {
            encPassWithoutPrefix = encPass.substring(5);
            salt = null;
        }
        return this.encodePassword(rawPass, salt).endsWith(encPassWithoutPrefix);
    }

    public void setForceLowerCasePrefix(boolean forceLowerCasePrefix) {
        this.forceLowerCasePrefix = forceLowerCasePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

