/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import java.lang.reflect.Field;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class FieldUtils {
    private FieldUtils() {
    }

    public static String getAccessorName(String fieldName, Class type) {
        Assert.hasText((String)fieldName, (String)"FieldName required");
        Assert.notNull((Object)type, (String)"Type required");
        if (type.getName().equals("boolean")) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    public static Field getField(Class clazz, String fieldName) throws IllegalStateException {
        Assert.notNull((Object)clazz, (String)"Class required");
        Assert.hasText((String)fieldName, (String)"Field name required");
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsf) {
            if (clazz.getSuperclass() != null) {
                return FieldUtils.getField(clazz.getSuperclass(), fieldName);
            }
            throw new IllegalStateException("Could not locate field '" + fieldName + "' on class " + clazz);
        }
    }

    public static String getMutatorName(String fieldName) {
        Assert.hasText((String)fieldName, (String)"FieldName required");
        return "set" + StringUtils.capitalize((String)fieldName);
    }

    public static Object getProtectedFieldValue(String protectedField, Object object) {
        Field field = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
            return null;
        }
    }

    public static void setProtectedFieldValue(String protectedField, Object object, Object newValue) {
        Field field = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field.setAccessible(true);
            field.set(object, newValue);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
    }
}

