/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.module.ModuleManager;
import com.wavemaker.runtime.server.ServerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class FileController
extends AbstractController {
    private static final String WM_BUILD_GZIPPED_URL = "/lib/build/Gzipped/";
    private static final String WM_BUILD_DOJO_THEMES_URL = "/lib/build/themes/";
    private static final String WM_BUILD_WM_THEMES_URL = "/lib/wm/base/widget/themes/";
    private static final String WM_BUILD_DOJO_FOLDER_URL = "/lib/dojo/";
    private static final String WM_BUILD_DOJO_JS_URL = "/lib/dojo/dojo/dojo_build.js";
    private static final String WM_BOOT_URL = "/lib/boot/boot.js";
    private static final String WM_RUNTIME_LOADER_URL = "/lib/runtimeLoader.js";
    private static final String WM_IMAGE_URL = "/resources/images/";
    private static final String WM_GZIPPED_URL = "/resources/gzipped/";
    private static final String WM_STUDIO_BUILD_URL = "/build/";
    private static final String WM_CONFIG_URL = "/config.js";
    private static final String SERVER_TIME = "{serverTimeOffset}";
    private ModuleManager moduleManager;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = WMAppContext.getInstance().getAppContextRoot();
        boolean isGzipped = false;
        boolean addExpiresTag = false;
        String reqPath = request.getRequestURI();
        String contextPath = request.getContextPath();
        reqPath = reqPath.replaceAll("%20", " ");
        reqPath = reqPath.replaceAll("//", "/");
        if (!contextPath.equals("") && reqPath.startsWith(contextPath)) {
            reqPath = reqPath.substring(reqPath.indexOf(47, 1));
        }
        if (reqPath.startsWith(WM_BUILD_GZIPPED_URL) || reqPath.startsWith(WM_GZIPPED_URL) || reqPath.equals(WM_BUILD_DOJO_JS_URL)) {
            isGzipped = true;
            addExpiresTag = true;
            reqPath = reqPath + ".gz";
        } else if (reqPath.startsWith(WM_BUILD_DOJO_THEMES_URL) || reqPath.startsWith(WM_BUILD_WM_THEMES_URL) || reqPath.startsWith(WM_BUILD_DOJO_FOLDER_URL) || reqPath.equals(WM_BOOT_URL) || reqPath.equals(WM_RUNTIME_LOADER_URL) || reqPath.startsWith(WM_IMAGE_URL) || reqPath.startsWith(WM_STUDIO_BUILD_URL)) {
            addExpiresTag = true;
        } else if (!reqPath.contains(WM_CONFIG_URL)) {
            throw new WMRuntimeException(Resource.STUDIO_UNKNOWN_LOCATION, new Object[]{reqPath, request.getRequestURI()});
        }
        File sendFile = null;
        if (!isGzipped && reqPath.lastIndexOf(".js") == reqPath.length() - 3) {
            sendFile = new File(path, reqPath + ".gz");
            if (!sendFile.exists()) {
                sendFile = null;
            } else {
                isGzipped = true;
            }
        }
        if (sendFile == null) {
            sendFile = new File(path, reqPath);
        }
        if (DataServiceLoggers.fileControllerLogger.isDebugEnabled()) {
            DataServiceLoggers.fileControllerLogger.debug((Object)("FileController: " + sendFile.getAbsolutePath() + "\t (" + reqPath + ")"));
        }
        if (null != sendFile && !sendFile.exists()) {
            this.handleError(response, "File " + reqPath + " not found in expected path: " + sendFile, 404);
        } else if (null != sendFile) {
            if (addExpiresTag) {
                FileController.setCacheExpireDate(response, 31536000);
            }
            if (!isGzipped) {
                this.setContentType(response, sendFile);
            } else {
                response.setHeader("Content-Encoding", "gzip");
            }
            ServletOutputStream os = response.getOutputStream();
            FileInputStream is = new FileInputStream(sendFile);
            if (reqPath.contains(WM_CONFIG_URL)) {
                String content = IOUtils.toString(is);
                content = content + "\r\nwm.serverTimeOffset = " + ServerUtils.getServerTimeOffset() + ";";
                String language = request.getHeader("accept-language");
                if (language != null && language.length() > 0) {
                    int index = language.indexOf(",");
                    language = index == -1 ? language : language.substring(0, index);
                    content = content + "\r\nwm.localeString = '" + language + "';";
                }
                IOUtils.write(content, (OutputStream)os);
            } else {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            os.close();
            ((InputStream)is).close();
        }
        return null;
    }

    public static void setCacheExpireDate(HttpServletResponse response, int seconds) {
        if (response != null) {
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(13, seconds);
            response.setHeader("Cache-Control", "PUBLIC, max-age=" + seconds + ", must-revalidate");
            response.setHeader("Expires", FileController.htmlExpiresDateFormat().format(cal.getTime()));
        }
    }

    public static DateFormat htmlExpiresDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat;
    }

    protected void handleError(HttpServletResponse response, String errorMessage, int code) throws IOException {
        response.setStatus(code);
        PrintWriter outputWriter = response.getWriter();
        ((Writer)outputWriter).write(errorMessage);
    }

    protected void setContentType(HttpServletResponse response, File file) {
        ConfigurableMimeFileTypeMap mimeFileTypeMap = new ConfigurableMimeFileTypeMap();
        mimeFileTypeMap.setMappings(new String[]{"text/css css CSS", "application/json json JSON smd SMD"});
        response.setContentType(mimeFileTypeMap.getContentType(file));
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }
}

