/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.RuntimeAccess;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.io.IOUtils;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.json.JSONObject;
import org.springframework.web.context.support.ServletContextResource;

public class WMAppContext {
    private static WMAppContext instance;
    private int defaultTenantID = 999;
    private String tenantFieldName = "None";
    private String tenantColumnName = "";
    private HashMap<String, ProjectInfo> hm;
    ServletContext context;
    private String appName;
    private static HashMap<String, Integer> tenantIdMap;
    private static HashMap<String, String> userNameMap;
    private JSONObject typesObj;
    private CloudEnvironment cloudEnvironment = new CloudEnvironment();

    private WMAppContext(ServletContextEvent event) {
        this.context = event.getServletContext();
        this.appName = this.context.getServletContextName();
        if (this.appName == null) {
            this.appName = "Project Name";
        }
        if (!this.appName.equals("WaveMaker Studio")) {
            Properties props;
            try {
                ServletContextResource typesResource = new ServletContextResource(this.context, "/types.js");
                String s = IOUtils.toString(typesResource.getInputStream());
                this.typesObj = new JSONObject(s.substring(11));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            ServletContextResource appPropsResource = null;
            try {
                appPropsResource = new ServletContextResource(this.context, "/WEB-INF/app.properties");
            }
            catch (WMRuntimeException re) {
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (!appPropsResource.exists()) {
                return;
            }
            try {
                props = new Properties();
                InputStream is = appPropsResource.getInputStream();
                props.load(is);
                is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            this.tenantFieldName = props.getProperty("tenantIdField");
            this.tenantColumnName = props.getProperty("tenantIdColumn");
            this.defaultTenantID = Integer.parseInt(props.getProperty("defTenantId"));
        }
    }

    public static synchronized WMAppContext getInstance(ServletContextEvent event) {
        if (instance == null) {
            instance = new WMAppContext(event);
        }
        return instance;
    }

    public static synchronized WMAppContext getInstance() {
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int getDefaultTenantID() {
        if (this.appName.equals("WaveMaker Studio")) {
            String p = (String)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectName");
            if (this.hm == null) {
                return 999;
            }
            ProjectInfo pi = this.hm.get(p);
            if (pi == null) {
                return 999;
            }
            return pi.defTenantId;
        }
        return this.defaultTenantID;
    }

    public String getTenantFieldName() {
        if (this.appName.equals("WaveMaker Studio")) {
            String p = (String)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectName");
            if (this.hm == null) {
                return "None";
            }
            ProjectInfo pi = this.hm.get(p);
            if (pi == null) {
                return "None";
            }
            return pi.tenantFldName;
        }
        return this.tenantFieldName;
    }

    public String getTenantColumnName() {
        if (this.appName.equals("WaveMaker Studio")) {
            String p = (String)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectName");
            if (this.hm == null) {
                return "";
            }
            ProjectInfo pi = this.hm.get(p);
            if (pi == null) {
                return "";
            }
            return pi.tenantColName;
        }
        return this.tenantColumnName;
    }

    public void setTenantInfoForProj(String projName, String val1, int val2, String val3) {
        if (this.hm == null) {
            this.hm = new HashMap();
        }
        ProjectInfo pi = new ProjectInfo(val1, val2, val3);
        this.hm.put(projName, pi);
    }

    public boolean isMultiTenant() {
        String tf;
        if (this.appName.equals("WaveMaker Studio")) {
            ProjectInfo pi;
            String p = (String)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectName");
            tf = this.hm == null ? "None" : ((pi = this.hm.get(p)) == null ? "None" : pi.tenantFldName);
        } else {
            tf = this.tenantFieldName;
        }
        boolean multiTenancy = !tf.equalsIgnoreCase("None") && tf.length() != 0 && tf != null;
        return multiTenancy;
    }

    public boolean isCloudFoundry() {
        return this.cloudEnvironment.getInstanceInfo() != null;
    }

    public void setTenantIdForUser(String userName, int tenantId) {
        tenantIdMap.put(userName, tenantId);
    }

    public int getTenantIdForUser(String userName) {
        return tenantIdMap.get(userName);
    }

    public void setUserNameForUserID(String userId, String userName) {
        userNameMap.put(userId, userName);
    }

    public String getUserNameForUserID(String userId) {
        return userNameMap.get(userId);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppContextRoot() {
        return this.context.getRealPath("");
    }

    public JSONObject getTypesObject() {
        return this.typesObj;
    }

    public void setTypesObject(JSONObject val) {
        this.typesObj = val;
    }

    static {
        tenantIdMap = new HashMap();
        userNameMap = new HashMap();
    }

    class ProjectInfo {
        String tenantFldName;
        int defTenantId;
        String tenantColName;

        private ProjectInfo(String val1, int val2, String val3) {
            this.tenantFldName = val1;
            this.defTenantId = val2;
            this.tenantColName = val3;
        }
    }
}

