/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DefaultTaskManager;
import com.wavemaker.runtime.data.ThreadContext;
import com.wavemaker.runtime.data.util.SystemUtils;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.events.ServiceEventListener;

public class DataServiceEventListener
implements ServiceEventListener {
    public Object[] preOperation(ServiceWire serviceWire, String operationName, Object[] params) {
        if (DataServiceLoggers.eventLogger.isInfoEnabled()) {
            DataServiceLoggers.eventLogger.info((Object)("startOperation " + operationName));
        }
        if (DataServiceLoggers.eventLogger.isDebugEnabled()) {
            if (params.length == 0) {
                DataServiceLoggers.eventLogger.debug((Object)"No input");
            } else {
                DataServiceLoggers.eventLogger.debug((Object)("Input " + ObjectUtils.objectToStringRecursive((Object)params[0])));
            }
        }
        ThreadContext.setPreProcessorTask(DefaultTaskManager.getInstance().getPreProcessorRouterTask());
        return params;
    }

    public TypedServiceReturn postOperation(ServiceWire serviceWire, String operationName, TypedServiceReturn result, Throwable th) throws Throwable {
        this.cleanup();
        if (th != null) {
            if (DataServiceLoggers.eventLogger.isInfoEnabled()) {
                DataServiceLoggers.eventLogger.info((Object)("failedOperation " + operationName + ": " + th));
            }
            throw th;
        }
        SystemUtils.clientPrepare();
        if (DataServiceLoggers.eventLogger.isInfoEnabled()) {
            DataServiceLoggers.eventLogger.info((Object)("postOperation " + operationName));
        }
        return result;
    }

    private void cleanup() {
        ThreadContext.unsetPreProcessorTask();
    }
}

