/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.cloudfoundry;

import com.wavemaker.runtime.data.spring.ConfigurationAndSessionFactoryBean;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.RdbmsServiceInfo;
import org.cloudfoundry.runtime.service.relational.RdbmsServiceCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.util.CollectionUtils;

public class CloudFoundryDataServiceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log log = LogFactory.getLog(CloudFoundryDataServiceBeanFactoryPostProcessor.class);
    private static final String DS_BEAN_SUFFIX = "DataSource";
    private final CloudEnvironment cloudEnvironment = new CloudEnvironment();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        if (CollectionUtils.isEmpty((Collection)this.cloudEnvironment.getServices())) {
            return;
        }
        this.processDataSources(defaultListableBeanFactory);
        this.processHibernateProperties(defaultListableBeanFactory);
    }

    private void processHibernateProperties(DefaultListableBeanFactory beanFactory) {
        String[] sessionFactoryBeanNames;
        for (String sfBean : sessionFactoryBeanNames = beanFactory.getBeanNamesForType(ConfigurationAndSessionFactoryBean.class)) {
            BeanDefinition beanDefinition = this.getBeanDefinition(beanFactory, sfBean);
            beanDefinition.setLazyInit(false);
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            PropertyValue hibernateProperties = propertyValues.getPropertyValue("hibernateProperties");
            ManagedProperties hibernatePropsPropertyValue = null;
            if (hibernateProperties != null) {
                TypedStringValue dialect;
                Object value = hibernateProperties.getValue();
                if (!(value instanceof ManagedProperties) || (dialect = (TypedStringValue)(hibernatePropsPropertyValue = (ManagedProperties)hibernateProperties.getValue()).get((Object)new TypedStringValue("hibernate.dialect"))) == null || !dialect.equals((Object)new TypedStringValue("com.wavemaker.runtime.data.dialect.MySQLDialect"))) continue;
                hibernatePropsPropertyValue.put((Object)new TypedStringValue("hibernate.dialect"), (Object)new TypedStringValue("org.hibernate.dialect.MySQLDialect"));
                continue;
            }
            hibernatePropsPropertyValue = new ManagedProperties();
        }
    }

    private BeanDefinition getBeanDefinition(DefaultListableBeanFactory beanFactory, String beanName) {
        if (beanName.startsWith("&")) {
            beanName = beanName.substring("&".length());
        }
        return beanFactory.getBeanDefinition(beanName);
    }

    private void processDataSources(DefaultListableBeanFactory defaultListableBeanFactory) {
        String[] dataSourceBeanNames = defaultListableBeanFactory.getBeanNamesForType(DataSource.class);
        if (dataSourceBeanNames.length <= 1) {
            return;
        }
        for (String dsBean : dataSourceBeanNames) {
            RdbmsServiceInfo service;
            if (!dsBean.endsWith(DS_BEAN_SUFFIX)) continue;
            String serviceName = dsBean.substring(0, dsBean.indexOf(DS_BEAN_SUFFIX));
            if (!this.serviceExists(serviceName)) {
                boolean foundAlias = false;
                for (String alias : defaultListableBeanFactory.getAliases(dsBean)) {
                    if (!this.serviceExists(alias)) continue;
                    serviceName = alias;
                    foundAlias = true;
                    break;
                }
                if (!foundAlias) {
                    log.warn((Object)("Expected to find a service with the name '" + serviceName + "' but none was found."));
                    continue;
                }
            }
            if ((service = (RdbmsServiceInfo)this.cloudEnvironment.getServiceInfo(serviceName, RdbmsServiceInfo.class)) != null) {
                defaultListableBeanFactory.removeBeanDefinition(dsBean);
                DataSource cfDataSource = (DataSource)new RdbmsServiceCreator().createService((AbstractServiceInfo)service);
                defaultListableBeanFactory.registerSingleton(dsBean, (Object)cfDataSource);
                continue;
            }
            log.warn((Object)("Service " + serviceName + " exists, but is not an RDBMS service as expected."));
        }
    }

    private boolean serviceExists(String serviceName) {
        List services = this.cloudEnvironment.getServices();
        for (Map serviceProps : services) {
            if (!serviceName.equals(serviceProps.get("name"))) continue;
            return true;
        }
        return false;
    }
}

