/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.hibernate;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.OneToManyMap;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataOperationFactory;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.DataServiceOperationManager;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.spring.ConfigurationRegistry;
import com.wavemaker.runtime.data.util.DataServiceConstants;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceMetaData_Hib
implements DataServiceMetaData {
    private final Configuration cfg;
    private DataServiceOperationManager operationManager = null;
    private final List<Class<?>> entityClasses = new ArrayList();
    private final Map<Class<?>, RootClass> rootClasses = new HashMap();
    private final OneToManyMap<String, Property> allProperties = new OneToManyMap();
    private final OneToManyMap<String, String> allPropertyNames = new OneToManyMap();
    private final OneToManyMap<String, Property> relProperties = new OneToManyMap();
    private final OneToManyMap<String, String> relPropertyNames = new OneToManyMap();
    private final Map<String, Map<String, Property>> allPropertiesMap = new HashMap<String, Map<String, Property>>();
    private final SortedSet<String> entityClassNames = new TreeSet<String>();
    private final SortedSet<String> componentClassNames = new TreeSet<String>();
    private final SortedSet<String> entityNames = new TreeSet<String>();
    private Collection<String> helperClassNames = Collections.emptySet();
    private final Set<String> refreshEntities;
    private final String configurationName;
    private String serviceClassName = null;

    public DataServiceMetaData_Hib(String configurationName, Configuration cfg) {
        this(configurationName, cfg, Collections.emptyMap());
    }

    public DataServiceMetaData_Hib(String configurationName, Configuration cfg, Map<String, String> properties) {
        this.configurationName = configurationName;
        this.cfg = cfg;
        String s = properties.get("refreshEntities");
        this.refreshEntities = s == null ? Collections.emptySet() : new HashSet<String>(StringUtils.split((String)s));
        this.initMappingData();
    }

    @Override
    public void init(Session session, boolean useIndividualCRUDOperations) {
        DataOperationFactory fac = this.initFactory(session);
        this.operationManager = new DataServiceOperationManager(fac, useIndividualCRUDOperations);
    }

    @Override
    public void init(String configurationName) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return this.configurationName;
    }

    @Override
    public String getServiceClassName() {
        return this.serviceClassName;
    }

    @Override
    public void setHelperClassNames(Collection<String> helperClassNames) {
        this.helperClassNames = helperClassNames;
    }

    @Override
    public Collection<String> getHelperClassNames() {
        return this.helperClassNames;
    }

    @Override
    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.cfg;
    }

    private void initMappingData() {
        Iterator iter = CastUtils.cast((Iterator)this.getConfiguration().getClassMappings());
        while (iter.hasNext()) {
            Object obj = iter.next();
            RootClass rc = obj instanceof RootClass ? (RootClass)obj : ((Subclass)obj).getRootClass();
            String s = rc.getClassName();
            this.entityClassNames.add(s);
            this.entityNames.add((String)StringUtils.splitPackageAndClass((String)s).v2);
            this.rootClasses.put(rc.getMappedClass(), rc);
            this.entityClasses.add(rc.getMappedClass());
            HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
            this.allPropertiesMap.put(rc.getClassName(), propertiesMap);
            Iterator iter2 = CastUtils.cast((Iterator)rc.getPropertyIterator());
            while (iter2.hasNext()) {
                Property p = (Property)iter2.next();
                this.initProperty(rc.getClassName(), p, propertiesMap);
            }
            Property id = rc.getIdentifierProperty();
            this.initProperty(rc.getClassName(), id, propertiesMap);
        }
    }

    private void initProperty(String owningClassName, Property p, Map<String, Property> propertiesMap) {
        this.allProperties.put((Object)owningClassName, (Object)p);
        if (p != null) {
            this.allPropertyNames.put((Object)owningClassName, (Object)p.getName());
            propertiesMap.put(p.getName(), p);
            Value v = p.getValue();
            if (v.getType().isEntityType() || !v.isSimpleValue()) {
                this.relProperties.put((Object)owningClassName, (Object)p);
                this.relPropertyNames.put((Object)owningClassName, (Object)p.getName());
            }
            if (p.getType().isComponentType()) {
                this.addComponentProperties(p);
            }
        }
    }

    private void addComponentProperties(Property p) {
        String s = p.getType().getReturnedClass().getName();
        this.componentClassNames.add(s);
        Value v = p.getValue();
        Component comp = (Component)v;
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        this.allPropertiesMap.put(s, propertiesMap);
        Iterator iter = CastUtils.cast((Iterator)comp.getPropertyIterator());
        while (iter.hasNext()) {
            Property p2 = (Property)iter.next();
            this.initProperty(s, p2, propertiesMap);
        }
    }

    @Override
    public Collection<String> getEntityClassNames() {
        return this.entityClassNames;
    }

    @Override
    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }

    @Override
    public boolean refreshEntity(Class<?> c) {
        if (!this.isEntity(c)) {
            throw new DataServiceRuntimeException(c + " is not an entity");
        }
        return this.refreshEntities.contains(c.getName());
    }

    @Override
    public String getIdPropertyName(Class<?> c) {
        if (!this.isEntity(c)) {
            throw new DataServiceRuntimeException(c + " is not an entity");
        }
        RootClass rc = this.getRootClass(c);
        Property id = rc.getIdentifierProperty();
        return id.getName();
    }

    @Override
    public boolean isCompositeProperty(Class<?> c, String propertyName) {
        if (!this.isEntity(c)) {
            throw new DataServiceRuntimeException(c + " is not an entity");
        }
        RootClass rc = this.getRootClass(c);
        Property p = rc.getProperty(propertyName);
        return p.isComposite();
    }

    @Override
    public Collection<String> getRelPropertyNames(Class<?> c) {
        if (!this.isEntity(c)) {
            throw new DataServiceRuntimeException(c + " is not an entity");
        }
        Collection rtn = this.relPropertyNames.get((Object)c.getName());
        if (rtn == null) {
            return Collections.emptyList();
        }
        return rtn;
    }

    @Override
    public Property getProperty(String className, String propertyName) {
        this.ensureEntityOrComponent(className);
        return this.allPropertiesMap.get(className).get(propertyName);
    }

    @Override
    public String getDataPackage() {
        Configuration cfg = this.getConfiguration();
        RootClass rc = (RootClass)cfg.getClassMappings().next();
        String className = rc.getClassName();
        return StringUtils.fromLastOccurrence((String)className, (String)".", (int)-1);
    }

    @Override
    public boolean isEntity(Class<?> c) {
        return this.getRootClass(c) != null;
    }

    @Override
    public Collection<String> getOperationNames() {
        return this.operationManager.getOperationNames();
    }

    @Override
    public NamedQueryDefinition getQueryDefinition(String queryName) {
        Configuration cfg = this.getConfiguration();
        NamedQueryDefinition rtn = (NamedQueryDefinition)cfg.getNamedQueries().get(queryName);
        if (rtn == null) {
            rtn = (NamedQueryDefinition)cfg.getNamedSQLQueries().get(queryName);
        }
        return rtn;
    }

    @Override
    public NamedQueryDefinition getHqlQueryDefinition(String queryName) {
        Configuration cfg = this.getConfiguration();
        NamedQueryDefinition rtn = (NamedQueryDefinition)cfg.getNamedQueries().get(queryName);
        return rtn;
    }

    @Override
    public NamedQueryDefinition getSqlQueryDefinition(String queryName) {
        Configuration cfg = this.getConfiguration();
        NamedQueryDefinition rtn = (NamedQueryDefinition)cfg.getNamedSQLQueries().get(queryName);
        return rtn;
    }

    @Override
    public DataServiceOperation getOperation(String operationName) {
        DataServiceOperation rtn = this.operationManager.getOperation(operationName);
        if (rtn == null) {
            throw new DataServiceRuntimeException(Resource.OPERATION_NOT_FOUND, this.configurationName, operationName, this.operationManager.getOperationNames());
        }
        return rtn;
    }

    private RootClass getRootClass(Class<?> c) {
        return this.rootClasses.get(c);
    }

    private String getJavaTypeName(Type type) {
        SessionFactory fac = ConfigurationRegistry.getInstance().getSessionFactory(this.configurationName);
        return DataServiceUtils.getJavaTypeName(type, fac);
    }

    private void ensureEntityOrComponent(String className) {
        if (!this.entityClassNames.contains(className) && !this.componentClassNames.contains(className)) {
            throw new IllegalArgumentException("Unknown Entity or Component class: " + className);
        }
    }

    private DataOperationFactory initFactory(final Session session) {
        return new DataOperationFactory(){
            private static final String GENERATED_QUERY_NAME = "ExampleHQLQuery1";

            @Override
            public Collection<String> getEntityClassNames() {
                return DataServiceMetaData_Hib.this.entityClassNames;
            }

            public List<Tuple.Three<String, String, Boolean>> getQueryInputs(String queryName) {
                ArrayList<Tuple.Three<String, String, Boolean>> rtn = new ArrayList<Tuple.Three<String, String, Boolean>>();
                NamedQueryDefinition def = DataServiceMetaData_Hib.this.getQueryDefinition(queryName);
                Map m = CastUtils.cast((Map)def.getParameterTypes());
                for (Map.Entry e : m.entrySet()) {
                    Tuple.Two<String, Boolean> t = DataServiceUtils.getQueryType((String)e.getValue());
                    rtn.add((Tuple.Three<String, String, Boolean>)Tuple.tuple(e.getKey(), (Object)t.v1, (Object)t.v2));
                }
                return rtn;
            }

            @Override
            public Collection<String> getQueryNames() {
                HashSet<String> rtn = new HashSet<String>();
                Configuration cfg = DataServiceMetaData_Hib.this.getConfiguration();
                rtn.addAll(cfg.getNamedQueries().keySet());
                rtn.addAll(cfg.getNamedSQLQueries().keySet());
                return rtn;
            }

            @Override
            public List<String> getQueryReturnNames(String operationName, String queryName) {
                Query query = session.getNamedQuery(queryName);
                try {
                    String[] names = query.getReturnAliases();
                    if (names != null) {
                        return Arrays.asList(names);
                    }
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
                return Collections.emptyList();
            }

            @Override
            public boolean requiresResultWrapper(String operationName, String queryName) {
                NamedQueryDefinition query = DataServiceMetaData_Hib.this.getQueryDefinition(queryName);
                return DataServiceUtils.requiresResultWrapper(query.getQuery());
            }

            @Override
            public List<String> getQueryReturnTypes(String operationName, String queryName) {
                ArrayList<String> rtn = new ArrayList<String>();
                Type[] rtnTypes = this.getReturnTypes(queryName);
                String queryString = DataServiceMetaData_Hib.this.getQueryDefinition(queryName).getQuery();
                if (rtnTypes == null) {
                    if (!DataServiceUtils.isDML(queryString)) {
                        // empty if block
                    }
                    rtn.add(DataServiceConstants.DML_OPERATION_RTN_TYPE.getName());
                } else if (DataServiceUtils.isDynamicInstantiationQuery(queryString)) {
                    String className = DataServiceUtils.getDynamicInstantiationClassName(queryString);
                    if (!StringUtils.isFullyQualified((String)className) && DataServiceMetaData_Hib.this.entityNames.contains(className)) {
                        className = StringUtils.fq((String)DataServiceMetaData_Hib.this.getDataPackage(), (String)className);
                    }
                    rtn.add(className);
                } else {
                    for (Type t : rtnTypes) {
                        rtn.add(DataServiceMetaData_Hib.this.getJavaTypeName(t));
                    }
                }
                return rtn;
            }

            @Override
            public boolean queryReturnsSingleResult(String operationName, String queryName) {
                if (queryName.equals(GENERATED_QUERY_NAME)) {
                    return true;
                }
                return queryName.startsWith("get") && queryName.endsWith("ById");
            }

            private Type[] getReturnTypes(String queryName) {
                Type[] rtn;
                block2: {
                    rtn = null;
                    Query query = session.getNamedQuery(queryName);
                    try {
                        rtn = query.getReturnTypes();
                    }
                    catch (RuntimeException ex) {
                        if (!DataServiceLoggers.metaDataLogger.isDebugEnabled()) break block2;
                        DataServiceLoggers.metaDataLogger.debug((Object)("Failed to determine rtn type for query \"" + queryName + "\""));
                    }
                }
                return rtn;
            }
        };
    }
}

