/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.parser;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseHbmParser {
    private Reader reader = null;
    protected XMLStreamReader xmlReader = null;
    protected String currentElementName = null;
    protected StringBuilder currentText = new StringBuilder();

    public abstract void initAll();

    protected BaseHbmParser() {
    }

    protected BaseHbmParser(String s) {
        this(new StringReader(s));
    }

    protected BaseHbmParser(File f) {
        this(BaseHbmParser.init(f));
    }

    protected BaseHbmParser(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        this.reader = reader;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            BaseHbmParser.setupEntityResolver(factory);
            this.xmlReader = factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
    }

    protected String nextNested(String parentElementName, String ... elementNames) {
        if (elementNames.length == 0) {
            throw new AssertionError((Object)"nextNested requires at least 2 args");
        }
        return this.nextInternal(parentElementName, -1, elementNames);
    }

    protected String next(String ... elementNames) {
        return this.nextInternal(null, -1, elementNames);
    }

    public void close() {
        try {
            this.xmlReader.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String next() {
        return this.nextInternal(null, 1, null);
    }

    protected String nextCharacterData() {
        return this.nextInternal(this.currentElementName, -1, null);
    }

    protected String nextInternal(String parentElementName, int numTries, String ... elementNames) {
        int i = 1;
        try {
            int event = this.xmlReader.next();
            while (event != 8) {
                switch (event) {
                    case 1: {
                        this.currentText.delete(0, this.currentText.length());
                        this.currentElementName = this.xmlReader.getName().toString();
                        if (numTries > -1) {
                            if (i == numTries) {
                                return this.currentElementName;
                            }
                            if (i > numTries) {
                                return null;
                            }
                        }
                        ++i;
                        if (elementNames == null) break;
                        for (String s : elementNames) {
                            if (!s.equals(this.currentElementName)) continue;
                            return this.currentElementName;
                        }
                        break;
                    }
                    case 2: {
                        String endElementName = this.xmlReader.getName().toString();
                        if (!endElementName.equals(parentElementName)) break;
                        return null;
                    }
                    case 4: {
                        this.currentText.append(this.xmlReader.getText());
                        break;
                    }
                }
                event = this.xmlReader.next();
            }
        }
        catch (XMLStreamException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return null;
    }

    private static Reader init(File f) {
        try {
            return new BufferedReader(new FileReader(f));
        }
        catch (IOException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
    }

    private static void setupEntityResolver(XMLInputFactory factory) {
        factory.setXMLResolver(new XMLResolver(){

            public Object resolveEntity(String publicId, String systemId, String s1, String s2) {
                if ("http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd".equals(systemId)) {
                    InputStream rtn = ClassLoaderUtils.getResourceAsStream((String)"com/wavemaker/tools/data/hibernate-mapping-3.0.dtd");
                    if (rtn == null) {
                        Log parserLogger = LogFactory.getLog((String)"com.wavemaker.tools.data.parser");
                        parserLogger.warn((Object)"Did not find local copy of \"hibernate-mapping-3.0.dtd\"");
                    } else {
                        return rtn;
                    }
                }
                return null;
            }
        });
    }
}

