/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.salesforce;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataOperationFactory;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.DataServiceOperationManager;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.Input;
import com.wavemaker.runtime.data.QueryInfo;
import com.wavemaker.runtime.data.parser.HbmQueryParser;
import com.wavemaker.runtime.ws.salesforce.SalesforceSupport;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.mapping.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceMetaData_SF
implements DataServiceMetaData {
    private DataServiceOperationManager operationManager = null;
    private final List<Class<?>> entityClasses = new ArrayList();
    private final SortedSet<String> entityClassNames = new TreeSet<String>();
    private final SortedSet<String> componentClassNames = new TreeSet<String>();
    private final SortedSet<String> entityNames = new TreeSet<String>();
    private Collection<String> helperClassNames = Collections.emptySet();
    private final Set<String> refreshEntities;
    private final String configurationName;
    private String serviceClassName = null;

    public DataServiceMetaData_SF(String configurationName) {
        this(configurationName, Collections.emptyMap());
    }

    public DataServiceMetaData_SF(String configurationName, Map<String, String> properties) {
        this.configurationName = configurationName;
        String s = properties.get("refreshEntities");
        this.refreshEntities = s == null ? Collections.emptySet() : new HashSet<String>(StringUtils.split((String)s));
        this.initMappingData();
    }

    @Override
    public void init(Session session, boolean useIndividualCRUDOperations) {
    }

    @Override
    public void init(String configurationName) {
        DataOperationFactory fac = this.initFactory(configurationName);
        this.operationManager = new DataServiceOperationManager(fac, false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getName() {
        return this.configurationName;
    }

    @Override
    public String getServiceClassName() {
        return this.serviceClassName;
    }

    @Override
    public void setHelperClassNames(Collection<String> helperClassNames) {
        this.helperClassNames = helperClassNames;
    }

    @Override
    public Collection<String> getHelperClassNames() {
        return this.helperClassNames;
    }

    @Override
    public void setServiceClassName(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    private void initMappingData() {
    }

    @Override
    public Collection<String> getEntityClassNames() {
        return this.entityClassNames;
    }

    @Override
    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }

    @Override
    public boolean refreshEntity(Class<?> c) {
        if (!this.isEntity(c)) {
            throw new DataServiceRuntimeException(c + " is not an entity");
        }
        return this.refreshEntities.contains(c.getName());
    }

    @Override
    public String getIdPropertyName(Class<?> c) {
        return null;
    }

    @Override
    public boolean isCompositeProperty(Class<?> c, String propertyName) {
        return false;
    }

    @Override
    public Collection<String> getRelPropertyNames(Class<?> c) {
        return null;
    }

    @Override
    public Property getProperty(String className, String propertyName) {
        return null;
    }

    @Override
    public String getDataPackage() {
        return null;
    }

    @Override
    public boolean isEntity(Class<?> c) {
        return false;
    }

    @Override
    public Collection<String> getOperationNames() {
        return this.operationManager.getOperationNames();
    }

    @Override
    public NamedQueryDefinition getQueryDefinition(String queryName) {
        return null;
    }

    @Override
    public DataServiceOperation getOperation(String operationName) {
        DataServiceOperation rtn = this.operationManager.getOperation(operationName);
        if (rtn == null) {
            throw new DataServiceRuntimeException(Resource.OPERATION_NOT_FOUND, this.configurationName, operationName, this.operationManager.getOperationNames());
        }
        return rtn;
    }

    @Override
    public NamedQueryDefinition getHqlQueryDefinition(String queryName) {
        return null;
    }

    @Override
    public NamedQueryDefinition getSqlQueryDefinition(String queryName) {
        return null;
    }

    private DataOperationFactory initFactory(String configurationName) {
        return new DataOperationFactory(){
            private static final String GENERATED_QUERY_NAME = "ExampleHQLQuery1";
            private static final String qfname = "com/sforce/queries/sforce-queries.xml";
            private HbmQueryParser p;
            private Map<String, QueryInfo> queries = null;
            {
                InputStream is = ClassLoaderUtils.getResourceAsStream((String)qfname);
                this.p = new HbmQueryParser(new InputStreamReader(is));
                this.queries = this.p.getQueries();
            }

            @Override
            public Collection<String> getEntityClassNames() {
                return DataServiceMetaData_SF.this.entityClassNames;
            }

            public List<Tuple.Three<String, String, Boolean>> getQueryInputs(String queryName) {
                Input[] inputs;
                ArrayList<Tuple.Three<String, String, Boolean>> rtn = new ArrayList<Tuple.Three<String, String, Boolean>>();
                for (Input input : inputs = this.queries.get(queryName).getInputs()) {
                    Tuple.Three t = new Tuple.Three((Object)input.getParamName(), (Object)input.getParamType(), (Object)input.getList());
                    rtn.add((Tuple.Three<String, String, Boolean>)t);
                }
                return rtn;
            }

            @Override
            public Collection<String> getQueryNames() {
                HashSet<String> rtn = new HashSet<String>();
                rtn.addAll(this.queries.keySet());
                return rtn;
            }

            @Override
            public List<String> getQueryReturnNames(String operationName, String queryName) {
                SalesforceSupport sfs = new SalesforceSupport();
                String query = this.queries.get(queryName).getQuery();
                List<String> fldList = sfs.getColumns(query);
                if (fldList == null || fldList.size() == 0) {
                    return Collections.emptyList();
                }
                ArrayList<String> rtn = new ArrayList<String>();
                int num = 0;
                for (String fld : fldList) {
                    String cnum = "" + num;
                    rtn.add(cnum);
                    ++num;
                }
                return rtn;
            }

            @Override
            public boolean requiresResultWrapper(String operationName, String queryName) {
                return true;
            }

            @Override
            public List<String> getQueryReturnTypes(String operationName, String queryName) {
                List<String> types;
                String query = this.queries.get(queryName).getQuery();
                SalesforceSupport sfs = new SalesforceSupport();
                try {
                    types = sfs.getColumnTypes(query);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                return types;
            }

            @Override
            public boolean queryReturnsSingleResult(String operationName, String queryName) {
                return false;
            }
        };
    }
}

