/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.salesforce;

import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.TaskManager;
import com.wavemaker.runtime.data.ThreadContext;
import com.wavemaker.runtime.data.salesforce.DataServiceMetaData_SF;
import com.wavemaker.runtime.data.task.DefaultRollback;
import com.wavemaker.runtime.ws.salesforce.SalesforceSupport;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.hibernate.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesforceDataServiceManager
implements DataServiceManager {
    public static final Log txLogger = DataServiceLoggers.transactionLogger;
    private final PlatformTransactionManager txMgr;
    private final TaskManager taskMgr;
    private final DataServiceMetaData metaData;

    public SalesforceDataServiceManager(PlatformTransactionManager txMgr, TaskManager taskMgr, Map<String, String> properties) {
        this.txMgr = txMgr;
        this.taskMgr = taskMgr;
        this.metaData = SalesforceDataServiceManager.initMetaData("salesforceService", properties);
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
    }

    @Override
    public Session getSession() {
        return null;
    }

    @Override
    public DataServiceMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object invoke(Task task, Object ... input) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Task task, Map<String, Class<?>> types, boolean named, Object ... input) {
        boolean unset = false;
        ThreadContext.Context ctx = ThreadContext.getContext(this.metaData.getName());
        if (ctx == null) {
            ctx = new ThreadContext.Context(this.txMgr, this.metaData, null, null);
            unset = true;
        }
        try {
            Object object = this.runInTx(task, types, named, input);
            return object;
        }
        finally {
            if (unset) {
                ThreadContext.unsetContext(this.metaData.getName());
            }
        }
    }

    private Object runInTx(Task task, Map<String, Class<?>> types, boolean named, Object ... input) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.txMgr);
        boolean rollbackOnly = task instanceof DefaultRollback && !this.isTxRunning();
        RunInTx tx = new RunInTx(rollbackOnly, types, named, input);
        if (txLogger.isInfoEnabled()) {
            if (this.isTxRunning()) {
                txLogger.info((Object)("tx is running executing \"" + task.getName() + "\" in current tx"));
            } else {
                txLogger.info((Object)("no tx running, wrapping execution of \"" + task.getName() + "\" in tx"));
                if (rollbackOnly) {
                    txLogger.info((Object)("rollback enabled for \"" + task.getName() + "\""));
                }
            }
        }
        Object rtn = txTemplate.execute((TransactionCallback)tx);
        if (txLogger.isInfoEnabled()) {
            if (this.isTxRunning()) {
                txLogger.info((Object)("tx is running after execution of \"" + task.getName() + "\""));
            } else {
                txLogger.info((Object)("tx is not running after execution of \"" + task.getName() + "\""));
            }
        }
        return rtn;
    }

    private boolean isTxRunning() {
        ThreadContext.Context ctx = ThreadContext.getContext(this.metaData.getName());
        if (ctx == null) {
            return false;
        }
        return ctx.getTransactionStatus() != null;
    }

    private static DataServiceMetaData initMetaData(String configurationName, Map<String, String> properties) {
        DataServiceMetaData_SF rtn = new DataServiceMetaData_SF(configurationName, properties);
        rtn.init(configurationName);
        return rtn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunInTx
    implements TransactionCallback {
        private final boolean rollbackOnly;
        private final Map<String, Class<?>> types;
        private final boolean named;
        private final Object[] input;

        RunInTx(boolean rollbackOnly, Map<String, Class<?>> types, boolean named, Object ... input) {
            this.rollbackOnly = rollbackOnly;
            this.types = types;
            this.named = named;
            this.input = input;
        }

        public Object doInTransaction(TransactionStatus status) {
            if (this.rollbackOnly) {
                status.setRollbackOnly();
            }
            SalesforceSupport sfs = new SalesforceSupport();
            List<Object> rtn = this.named ? sfs.runNamedQuery(this.types, this.input) : sfs.runQuery(this.types, this.input);
            return rtn;
        }
    }
}

