/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.spring;

import com.wavemaker.common.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationRegistry {
    private static final ConfigurationRegistry instance = new ConfigurationRegistry();
    private Map<String, Tuple.Two<Configuration, SessionFactory>> reg = new HashMap<String, Tuple.Two<Configuration, SessionFactory>>();

    public static ConfigurationRegistry getInstance() {
        return instance;
    }

    private ConfigurationRegistry() {
    }

    public synchronized void register(String name, Configuration configuration) {
        this.getEntry((String)name).v1 = configuration;
    }

    public synchronized void register(String name, SessionFactory sessionFactory) {
        this.getEntry((String)name).v2 = sessionFactory;
    }

    public synchronized Configuration getConfiguration(String name) {
        if (this.reg.get(name) == null) {
            return null;
        }
        return (Configuration)this.reg.get((Object)name).v1;
    }

    public synchronized SessionFactory getSessionFactory(String name) {
        if (this.reg.get(name) == null) {
            return null;
        }
        return (SessionFactory)this.reg.get((Object)name).v2;
    }

    public synchronized void remove(String name) {
        this.reg.remove(name);
    }

    private synchronized Tuple.Two<Configuration, SessionFactory> getEntry(String name) {
        Tuple.Two rtn = this.reg.get(name);
        if (rtn == null) {
            rtn = Tuple.tuple(null, null);
            this.reg.put(name, (Tuple.Two<Configuration, SessionFactory>)rtn);
        }
        return rtn;
    }
}

