/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.sqlserver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SqlServerUserImpersonatingDataSourceProxy
extends DelegatingDataSource {
    private String activeDirectoryDomain = "";

    public SqlServerUserImpersonatingDataSourceProxy() {
    }

    public SqlServerUserImpersonatingDataSourceProxy(DataSource targetDataSource) {
        super(targetDataSource);
    }

    public Connection getConnection() throws SQLException {
        DataSource ds = this.getTargetDataSource();
        Assert.state((ds != null ? 1 : 0) != 0, (String)"'targetDataSource' is required");
        return this.getAuditingConnectionProxy(this.getTargetDataSource().getConnection());
    }

    public void setActiveDirectoryDomain(String activeDirectoryDomain) {
        this.activeDirectoryDomain = activeDirectoryDomain;
    }

    public void setTargetDataSource(DataSource targetDataSource) {
        super.setTargetDataSource(targetDataSource);
    }

    private Connection getAuditingConnectionProxy(Connection connection) throws SQLException {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new AuditingInvocationHandler(connection));
    }

    private class AuditingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public AuditingInvocationHandler(Connection targetConnection) throws SQLException {
            this.target = targetConnection;
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null) {
                StringBuilder query = new StringBuilder();
                query.append("EXECUTE AS USER='");
                if (StringUtils.hasText((String)SqlServerUserImpersonatingDataSourceProxy.this.activeDirectoryDomain)) {
                    query.append(SqlServerUserImpersonatingDataSourceProxy.this.activeDirectoryDomain + "\\");
                }
                query.append(auth.getName() + "'");
                this.executeStatement(query.toString());
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return proxy;
                }
            } else if (method.getName().equals("isWrapperFor")) {
                if (((Class)args[0]).isInstance(proxy)) {
                    return true;
                }
            } else if (method.getName().equals("close")) {
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                if (auth != null) {
                    this.executeStatement("REVERT");
                }
            } else if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeStatement(String sql) throws SQLException {
            Statement statement = null;
            try {
                statement = this.target.createStatement();
                statement.execute(sql);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                JdbcUtils.closeStatement((Statement)statement);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)statement);
        }
    }
}

