/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ImmutableEntryMap;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.TypeConversionUtils;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.AbstractReadTask;
import com.wavemaker.runtime.data.task.DefaultRollback;
import com.wavemaker.runtime.service.Filter;
import com.wavemaker.runtime.service.PagingOptions;
import com.wavemaker.runtime.service.PropertyOptions;
import com.wavemaker.runtime.service.response.LiveDataServiceResponse;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaReadTask
extends AbstractReadTask
implements Task,
DefaultRollback {
    @Override
    public Object run(Session session, String dbName, Object ... input) {
        if (ObjectUtils.isNullOrEmpty((Object[])input)) {
            throw new IllegalArgumentException("input cannot be null or empty");
        }
        Class type = null;
        Object instance = null;
        PropertyOptions propertyOptions = null;
        PagingOptions pagingOptions = null;
        for (Object o : input) {
            if (o == null) continue;
            if (o instanceof Class) {
                type = (Class)o;
                continue;
            }
            if (PropertyOptions.class.isAssignableFrom(o.getClass())) {
                propertyOptions = (PropertyOptions)o;
                continue;
            }
            if (PagingOptions.class.isAssignableFrom(o.getClass())) {
                pagingOptions = (PagingOptions)o;
                continue;
            }
            instance = o;
        }
        if (type == null && instance == null) {
            throw new IllegalArgumentException("Either root type or instance must be set");
        }
        if (type == null) {
            type = instance.getClass();
        }
        ImmutableEntryMap criterias = new ImmutableEntryMap();
        Criteria rootCriteria = this.initCriteriasMap((Map<String, Criteria>)criterias, type, session);
        if (instance != null) {
            String idPropName = CriteriaReadTask.getMetaData(dbName).getIdPropertyName(type);
            Object value = this.getObjectAccess().getProperty(instance, idPropName);
            if (value != null) {
                this.addEqualsFilter(rootCriteria, idPropName, value);
            }
        }
        if (propertyOptions != null) {
            this.applyPropertyOptions(type, propertyOptions, (Map<String, Criteria>)criterias, dbName);
        }
        LiveDataServiceResponse rtn = new LiveDataServiceResponse();
        if (pagingOptions != null) {
            this.applyOrderBy(pagingOptions, (Map<String, Criteria>)criterias);
            this.applyPaging(pagingOptions, rootCriteria);
            if (pagingOptions.getMaxResults() != null) {
                rtn.setDataSetSize(pagingOptions.getMaxResults());
            }
        }
        rtn.setResult(rootCriteria.list());
        return rtn;
    }

    @Override
    public String getName() {
        return "Built-in CRUD Read Task";
    }

    private void applyPropertyOptions(Class<?> type, PropertyOptions options, Map<String, Criteria> criterias, String dbName) {
        for (String s : options.getProperties()) {
            this.getCriteriaForPath(s, criterias, true);
        }
        for (Filter f : options.getFilterList()) {
            Class<?> propType = this.getPropertyType(type, f.getPropertyPath(), dbName);
            Object value = TypeConversionUtils.fromString(propType, (String)f.getExpression());
            Tuple.Two<String, String> p = this.splitPath(f.getPropertyPath());
            Criteria c = this.getCriteriaForPath((String)p.v1, criterias);
            this.applyFilter(c, (String)p.v2, value);
        }
    }

    private void applyFilter(Criteria criteria, String property, Object value) {
        this.addEqualsFilter(criteria, property, value);
    }

    private void addEqualsFilter(Criteria criteria, String property, Object value) {
        criteria.add((Criterion)Restrictions.eq((String)property, (Object)value));
    }
}

