/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.TypeConversionUtils;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeDefinition;
import com.wavemaker.runtime.data.DataServiceLoggers;
import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.AbstractReadTask;
import com.wavemaker.runtime.data.task.DefaultRollback;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.data.util.HQLGenerator;
import com.wavemaker.runtime.service.Filter;
import com.wavemaker.runtime.service.OrderBy;
import com.wavemaker.runtime.service.PagingOptions;
import com.wavemaker.runtime.service.PropertyOptions;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.response.LiveDataServiceResponse;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQLReadTask
extends AbstractReadTask
implements Task,
DefaultRollback {
    private static final String BIND_PARAM_PREFIX = "_";
    private static final Object UNSET = new Object();
    private static final String ID_PROP_NAME = "id";
    private static final String ID_BIND_PARAM = "_id";

    @Override
    public Object run(Session session, String dbName, Object ... input) {
        if (ObjectUtils.isNullOrEmpty((Object[])input)) {
            throw new IllegalArgumentException("input cannot be null or empty");
        }
        Class type = null;
        Object instance = null;
        PropertyOptions propertyOptions = null;
        PagingOptions pagingOptions = null;
        LinkedHashMap<String, Object> bindParams = new LinkedHashMap<String, Object>();
        for (Object o : input) {
            if (o == null) continue;
            if (o instanceof Class) {
                type = (Class)o;
                continue;
            }
            if (o instanceof TypeDefinition) {
                if (o instanceof ReflectTypeDefinition) {
                    type = ((ReflectTypeDefinition)o).getKlass();
                    continue;
                }
                throw new IllegalArgumentException("ReflectTypeDefinition required, instead found " + o + " (" + o.getClass() + ")");
            }
            if (PropertyOptions.class.isAssignableFrom(o.getClass())) {
                propertyOptions = (PropertyOptions)o;
                continue;
            }
            if (PagingOptions.class.isAssignableFrom(o.getClass())) {
                pagingOptions = (PagingOptions)o;
                continue;
            }
            instance = o;
        }
        if (type == null && instance == null) {
            throw new IllegalArgumentException("Either root type or instance must be set");
        }
        if (type == null) {
            type = instance.getClass();
        }
        String idPropName = null;
        Object idValue = UNSET;
        if (instance != null) {
            idPropName = HQLReadTask.getMetaData(dbName).getIdPropertyName(type);
            idValue = this.getObjectAccess().getProperty(instance, idPropName);
            if (idValue == null) {
                throw new IllegalArgumentException(type.getName() + "'s " + idPropName + " must be set");
            }
        }
        HQLGenerator generator = this.setupGenerator(type, instance, propertyOptions, pagingOptions, idPropName, idValue, bindParams, dbName);
        return this.getResponse(session, generator, instance, pagingOptions, idValue, bindParams, dbName);
    }

    @Override
    public String getName() {
        return "Built-in CRUD Read Task";
    }

    private TypedServiceReturn getResponse(Session session, HQLGenerator generator, Object instance, PagingOptions pagingOptions, Object idValue, Map<String, Object> bindParams, String dbName) {
        String queryStr = generator.getQuery(dbName);
        this.logQuery(queryStr, bindParams);
        Query query = session.createQuery(queryStr);
        this.handleBindParameters(idValue, query, bindParams);
        HQLReadTask.applyPaging(pagingOptions, query);
        LiveDataServiceResponse rtn = new LiveDataServiceResponse();
        boolean singleResult = instance != null;
        rtn.setResult(this.runQuery(query, singleResult, dbName));
        if (pagingOptions != null) {
            String countQueryStr = generator.getCountQuery(dbName);
            this.logQuery(countQueryStr, bindParams);
            Query countQuery = session.createQuery(countQueryStr);
            this.handleBindParameters(idValue, countQuery, bindParams);
            rtn.setDataSetSize((Long)this.runQuery(countQuery, true, dbName));
        }
        TypedServiceReturn tsr = new TypedServiceReturn();
        tsr.setReturnValue(rtn);
        return tsr;
    }

    private void handleBindParameters(Object idValue, Query query, Map<String, Object> bindParams) {
        if (idValue == null) {
            if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
                DataServiceLoggers.taskLogger.debug((Object)"ignoring null id value");
            }
        } else if (idValue != UNSET) {
            query.setParameter(ID_BIND_PARAM, idValue);
            if (DataServiceLoggers.taskLogger.isDebugEnabled()) {
                DataServiceLoggers.taskLogger.debug((Object)("binding id value: " + idValue));
            }
        }
        for (String bindParam : bindParams.keySet()) {
            query.setParameter(bindParam, bindParams.get(bindParam));
        }
    }

    private HQLGenerator setupGenerator(Class<?> type, Object instance, PropertyOptions propertyOptions, PagingOptions pagingOptions, String idPropName, Object idValue, Map<String, Object> bindParams, String dbName) {
        HQLGenerator rtn = new HQLGenerator(type, new JoinStrategy(type), new TypeManager(type));
        if (propertyOptions != null) {
            this.handlePropertyOptions(type, rtn, propertyOptions, bindParams, dbName);
        }
        if (pagingOptions == null) {
            this.addDefaultOrder(rtn);
        } else {
            List<OrderBy> orders = pagingOptions.getOrderByList();
            if (orders.isEmpty()) {
                this.addDefaultOrder(rtn);
            } else {
                rtn.setOrderBy(pagingOptions.getOrderByList());
            }
        }
        if (idValue != null && idValue != UNSET) {
            rtn.addSelection(idPropName, "=" + this.getBindParamRef(ID_BIND_PARAM));
        }
        return rtn;
    }

    private void handlePropertyOptions(Class<?> type, HQLGenerator generator, PropertyOptions options, Map<String, Object> bindParams, String dbName) {
        generator.loadEagerly(options.getProperties());
        for (Filter f : options.getFilterList()) {
            String propertyPath = f.getPropertyPath();
            String s = f.getExpression();
            StringBuilder value = new StringBuilder();
            boolean isLike = false;
            boolean isStr = false;
            Class<?> propertyType = this.getPropertyType(type, propertyPath, dbName);
            boolean bl = isStr = String.class == propertyType;
            if (isStr) {
                MatchMode m = DataServiceUtils.parseMatchMode(options.getMatchMode());
                if (m == MatchMode.EXACT) {
                    value.append(s);
                } else {
                    isLike = true;
                    if (m == MatchMode.START) {
                        value.append(s).append("%");
                    } else if (m == MatchMode.END) {
                        value.append("%").append(s);
                    } else if (m == MatchMode.ANYWHERE) {
                        value.append("%").append(s).append("%");
                    }
                }
            }
            if (value.length() == 0) {
                value.append(s);
            }
            StringBuilder expr = new StringBuilder();
            if (isLike) {
                expr.append("like ");
            } else {
                expr.append("=");
            }
            String bindParam = this.getNextBindParam(bindParams.keySet());
            Object o = TypeConversionUtils.fromString(propertyType, (String)value.toString());
            expr.append(this.getBindParamRef(bindParam));
            if (isStr && options.isIgnoreCase()) {
                o = String.valueOf(o).toLowerCase();
                generator.addSelection(propertyPath, expr.toString(), true);
            } else {
                generator.addSelection(propertyPath, expr.toString(), false);
            }
            bindParams.put(bindParam, o);
        }
    }

    private void addDefaultOrder(HQLGenerator generator) {
        generator.addAscOrder(ID_PROP_NAME);
    }

    private String getBindParamRef(String bindParam) {
        return ":" + bindParam;
    }

    private String getNextBindParam(Collection<String> bindParams) {
        String rtn = StringUtils.getUniqueName((String)"_p", bindParams);
        return rtn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeManager
    implements HQLGenerator.TypeManager {
        private final Class<?> type;
        private final Collection<String> componentPropertyPaths = new HashSet<String>();

        private TypeManager(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean isComponentPath(String propertyPath, String dbName) {
            for (String s : this.componentPropertyPaths) {
                if (!propertyPath.startsWith(s)) continue;
                return true;
            }
            if (HQLReadTask.this.isComponentType(this.type, propertyPath, dbName)) {
                this.componentPropertyPaths.add(propertyPath);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinStrategy
    implements HQLGenerator.JoinStrategy {
        private final Class<?> type;
        private final Collection<String> outerJoinPropertyPaths = new HashSet<String>();

        private JoinStrategy(Class<?> type) {
            this.type = type;
        }

        @Override
        public HQLGenerator.JoinStrategy.Join getJoin(String propertyPath, String dbName) {
            for (String s : this.outerJoinPropertyPaths) {
                if (!propertyPath.startsWith(s)) continue;
                return HQLGenerator.JoinStrategy.Join.LEFT_OUTER_JOIN;
            }
            if (HQLReadTask.this.isNulleable(this.type, propertyPath, dbName)) {
                this.outerJoinPropertyPaths.add(propertyPath);
                return HQLGenerator.JoinStrategy.Join.LEFT_OUTER_JOIN;
            }
            return HQLGenerator.JoinStrategy.Join.INNER_JOIN;
        }
    }
}

