/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.task;

import com.wavemaker.runtime.data.Task;
import com.wavemaker.runtime.data.task.AbstractReadTask;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.PagingOptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTask
extends AbstractReadTask
implements Task {
    @Override
    public Object run(Session session, String dbName, Object ... input) {
        Object o;
        PagingOptions pagingOptions = null;
        if (input.length > 0 && (o = input[input.length - 1]) instanceof PagingOptions) {
            pagingOptions = (PagingOptions)o;
            Object[] ar = new Object[input.length - 1];
            System.arraycopy(input, 0, ar, 0, ar.length);
            input = ar;
        }
        Map<String, BindParameter> bindParams = this.handleBindParameters(input);
        Query query = this.createQuery(session, input);
        this.prepareQuery(query, bindParams, pagingOptions);
        return this.runQuery(query);
    }

    protected Map<String, BindParameter> handleBindParameters(Object ... input) {
        HashMap<String, BindParameter> rtn = new HashMap<String, BindParameter>();
        if (input.length > 1) {
            for (int i = 1; i < input.length; i += 2) {
                String name = (String)input[i];
                rtn.put(name, new BindParameter(name, input[i + 1]));
            }
        }
        return rtn;
    }

    protected Query createQuery(Session session, Object ... input) {
        return session.createQuery((String)input[0]);
    }

    protected Object runQuery(Query query) {
        if (DataServiceUtils.isDML(query.getQueryString())) {
            return query.executeUpdate();
        }
        return query.list();
    }

    protected void prepareQuery(Query query, Map<String, BindParameter> bindParams, PagingOptions pagingOptions) {
        for (Map.Entry<String, BindParameter> e : bindParams.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue().value;
            if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                query.setParameterList(name, (Collection)value);
                continue;
            }
            query.setParameter(name, value);
        }
        QueryTask.applyPaging(pagingOptions, query);
    }

    @Override
    public String getName() {
        return "Built-in Query Task";
    }

    class BindParameter {
        final String name;
        final String type;
        final Object value;

        BindParameter(String name, Object value) {
            this(name, null, value);
        }

        BindParameter(String name, String type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }
    }
}

