/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.ObjectGraphTraversal;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.DataServiceManagerAccess;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.service.ElementType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.MatchMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceUtils {
    private static final String WRAPPER_TYPE_SUFFX = "RtnType";
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static final String DEFAULT_ALIAS_PREFIX = "c";
    private static final ObjectAccess objectAccess = ObjectAccess.getInstance();

    public static RuntimeException unwrap(Throwable th) {
        InvalidDataAccessResourceUsageException e;
        if (InvalidDataAccessResourceUsageException.class.isAssignableFrom((th = SystemUtils.getRootException((Throwable)th)).getClass()) && (e = (InvalidDataAccessResourceUsageException)th).getRootCause() != null) {
            th = e.getRootCause();
        }
        if (SQLGrammarException.class.isAssignableFrom(th.getClass())) {
            SQLGrammarException s = (SQLGrammarException)th;
            if (s.getSQLException() != null) {
                th = s.getSQLException();
            } else if (s.getCause() != null) {
                th = s.getCause();
            }
        }
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new DataServiceRuntimeException(th);
    }

    public static String getJavaTypeName(Type type, SessionFactory factory) {
        if (type.isCollectionType()) {
            AssociationType ass = (AssociationType)type;
            SessionFactoryImplementor fai = (SessionFactoryImplementor)factory;
            return ass.getAssociatedEntityName(fai);
        }
        return type.getReturnedClass().getName();
    }

    public static boolean requiresResultWrapper(String queryString) {
        return queryString.trim().toLowerCase().startsWith("select");
    }

    public static String queryToOperationName(String queryName) {
        return StringUtils.lowerCaseFirstLetter((String)queryName);
    }

    public static String operationToQueryName(String operationName, Collection<String> queryNames) {
        if (queryNames.contains(operationName)) {
            return operationName;
        }
        return StringUtils.upperCaseFirstLetter((String)operationName);
    }

    public static boolean isProxy(Class<?> clazz) {
        return HibernateProxy.class.isAssignableFrom(clazz);
    }

    public static Class<?> getEntityClass(Class<?> clazz) {
        if (DataServiceUtils.isProxy(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static ObjectGraphTraversal getRelatedTraversal(ObjectGraphTraversal.ObjectVisitor visitor, final ObjectAccess objectAccess, final DataServiceMetaData metaData, final boolean skipToMany) {
        ObjectGraphTraversal.PropertyFactory pf = new ObjectGraphTraversal.PropertyFactory(){

            public Collection<String> getProperties(Object o, ObjectGraphTraversal.Context ctx) {
                Class<?> entityClass = DataServiceUtils.getEntityClass(o.getClass());
                if (!metaData.isEntity(entityClass)) {
                    return Collections.emptySet();
                }
                Collection<String> relPropNames = metaData.getRelPropertyNames(entityClass);
                if (!skipToMany) {
                    return relPropNames;
                }
                HashSet<String> rtn = new HashSet<String>();
                for (String propertyName : relPropNames) {
                    if (DataServiceUtils.isRelatedMany(objectAccess.getPropertyType(entityClass, propertyName))) continue;
                    rtn.add(propertyName);
                }
                return rtn;
            }
        };
        return new ObjectGraphTraversal(pf, visitor, objectAccess);
    }

    public static List<String> getColumnNames(int numOutputTypes, List<String> outputNames) {
        HashSet<String> usedNames = new HashSet<String>(numOutputTypes);
        ArrayList<String> rtn = new ArrayList<String>(numOutputTypes);
        for (int i = 0; i < numOutputTypes; ++i) {
            String name = DEFAULT_ALIAS_PREFIX + i;
            if (outputNames.size() > i && StringUtils.isNumber((String)(name = outputNames.get(i)))) {
                name = DEFAULT_ALIAS_PREFIX + name;
            }
            name = StringUtils.getUniqueName((String)name, usedNames);
            usedNames.add(name);
            rtn.add(name);
        }
        return rtn;
    }

    public static boolean isOutputType(String fqName) {
        return StringUtils.getPackage((String)fqName).endsWith(StringUtils.fq((String)"", (String)"output"));
    }

    public static String getOutputPackage(String dataPackage) {
        return StringUtils.fq((String)dataPackage, (String)"output");
    }

    public static String getOutputType(String dataPackage, String operationName) {
        return DataServiceUtils.getOldOutputType(dataPackage, operationName) + WRAPPER_TYPE_SUFFX;
    }

    public static String getOldOutputType(String dataPackage, String operationName) {
        return StringUtils.fq((String)DataServiceUtils.getOutputPackage(dataPackage), (String)StringUtils.upperCaseFirstLetter((String)operationName));
    }

    public static Configuration initConfiguration(String hbConfFile) {
        return DataServiceUtils.initConfiguration(hbConfFile, EMPTY_PROPERTIES);
    }

    public static Configuration initConfiguration(String hbConfFile, Properties p) {
        Configuration cfg = new Configuration().configure(hbConfFile);
        DataServiceUtils.setup(cfg, p);
        return cfg;
    }

    public static Configuration initConfiguration(File hbConfFile) {
        return DataServiceUtils.initConfiguration(hbConfFile, EMPTY_PROPERTIES);
    }

    public static Configuration initConfiguration(File hbConfFile, Properties p) {
        Configuration cfg = new Configuration().configure(hbConfFile);
        DataServiceUtils.setup(cfg, p);
        return cfg;
    }

    public static Properties toHibernateConnectionProperties(Properties p) {
        Properties rtn = new Properties();
        rtn.putAll((Map<?, ?>)p);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String name = (String)entry.getKey();
            String newName = null;
            if (name.endsWith(".username")) {
                newName = "hibernate.connection.username";
            } else if (name.endsWith(".password")) {
                newName = "hibernate.connection.password";
            } else if (name.endsWith(".driverClassName")) {
                newName = "hibernate.connection.driver_class";
            } else if (name.endsWith(".connectionUrl")) {
                newName = "hibernate.connection.url";
            } else if (name.endsWith(".dialect")) {
                newName = "hibernate.dialect";
            }
            if (newName == null || rtn.getProperty(newName) != null) continue;
            rtn.setProperty(newName, (String)entry.getValue());
        }
        return rtn;
    }

    public static List<ElementType> getTypes(Collection<String> entities, Collection<String> otherTypes, DataServiceInternal.ElementTypeFactory factory) {
        ArrayList<ElementType> rtn = new ArrayList<ElementType>(entities.size());
        for (String s : entities) {
            rtn.add(factory.getElementType(s));
        }
        HashSet els = new HashSet(rtn);
        for (ElementType el : els) {
            for (ElementType p : el.getProperties()) {
                if (!p.isTopLevel() || DataServiceUtils.containsElementType(rtn, p)) continue;
                rtn.add(p);
            }
        }
        for (String s : otherTypes) {
            rtn.add(factory.getElementType(s));
        }
        return rtn;
    }

    public static boolean isDML(String query) {
        String q = query.trim().toLowerCase();
        return q.startsWith("update") || q.startsWith("insert") || q.startsWith("delete");
    }

    public static boolean isDynamicInstantiationQuery(String query) {
        return DataServiceUtils.getDynamicInstantiationClassName(query) != null;
    }

    public static String getDynamicInstantiationClassName(String query) {
        String[] tokens = query.trim().split("\\s");
        if (tokens.length < 3) {
            return null;
        }
        if (!tokens[0].trim().equalsIgnoreCase("select")) {
            return null;
        }
        if (!tokens[1].trim().equalsIgnoreCase("new")) {
            return null;
        }
        String s = tokens[2].trim();
        int i = s.indexOf("(");
        if (i == -1) {
            return null;
        }
        return s.substring(0, i);
    }

    public static Object loadById(Object o, Session session, DataServiceMetaData metaData) {
        return DataServiceUtils.loadById(o, session, metaData, null);
    }

    public static Object loadById(Object originalInstance, Session session, DataServiceMetaData metaData, Log logger) {
        if (originalInstance == null) {
            throw new IllegalArgumentException("instance to reload cannot be null");
        }
        Class<?> clazz = DataServiceUtils.getEntityClass(originalInstance.getClass());
        String s = metaData.getIdPropertyName(clazz);
        Serializable id = (Serializable)objectAccess.getProperty(originalInstance, s);
        Object rtn = session.get(clazz, id);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((Object)("reloadById: " + ObjectUtils.getId((Object)originalInstance) + " " + s + ":" + id));
        }
        return rtn;
    }

    public static boolean isRelatedMany(Class<?> c) {
        return Map.class.isAssignableFrom(c) || Collection.class.isAssignableFrom(c);
    }

    public static Object mergeForUpdate(Object o, DataServiceManagerAccess mgrAccess, Collection<String> populatedProperties) {
        return DataServiceUtils.mergeForUpdate(o, mgrAccess.getDataServiceManager().getSession(), mgrAccess.getDataServiceManager().getMetaData(), populatedProperties);
    }

    public static Object mergeForUpdate(Object source, Session session, DataServiceMetaData metaData, Collection<String> populatedProperties) {
        String idPropName = metaData.getIdPropertyName(source.getClass());
        if (!populatedProperties.contains(idPropName)) {
            throw new DataServiceRuntimeException("id property \"" + idPropName + "\" must be set");
        }
        Object rtn = DataServiceUtils.loadById(source, session, metaData);
        if (rtn == null) {
            throw new DataServiceRuntimeException("Failed to load instance to update");
        }
        Collection<String> relatedPropertyNames = metaData.getRelPropertyNames(source.getClass());
        HashSet<String> handledPropertyPrefixes = new HashSet<String>();
        for (String propertyName : populatedProperties) {
            int i = propertyName.indexOf(".");
            if (i != -1) {
                propertyName = propertyName.substring(0, i);
            }
            if (handledPropertyPrefixes.contains(propertyName)) continue;
            Object clientValue = objectAccess.getProperty(source, propertyName);
            if (relatedPropertyNames.contains(propertyName)) {
                if (DataServiceUtils.isRelatedMany(objectAccess.getPropertyType(source.getClass(), propertyName))) continue;
                handledPropertyPrefixes.add(propertyName);
                if (clientValue != null) {
                    String prefix = propertyName + ".";
                    List populatedPropertiesForRelated = StringUtils.getItemsStartingWith(populatedProperties, (String)prefix, (boolean)true);
                    clientValue = DataServiceUtils.mergeForUpdate(clientValue, session, metaData, populatedPropertiesForRelated);
                }
            }
            objectAccess.setProperty(rtn, propertyName, clientValue);
        }
        return rtn;
    }

    public static Object mergeForInsert(Object source, Session session, DataServiceMetaData metaData) {
        return DataServiceUtils.mergeForInsert(source, session, metaData, true, new HashSet<Object>());
    }

    private static Object mergeForInsert(Object source, Session session, DataServiceMetaData metaData, boolean isRoot, Collection<Object> handledInstances) {
        if (handledInstances.contains(source)) {
            return source;
        }
        Class<?> entityClass = DataServiceUtils.getEntityClass(source.getClass());
        String idPropName = metaData.getIdPropertyName(entityClass);
        Object idPropVal = objectAccess.getProperty(source, idPropName);
        if (idPropVal != null) {
            if (isRoot) {
                return source;
            }
            Object o = DataServiceUtils.loadById(source, session, metaData);
            if (o != null) {
                handledInstances.add(o);
                return o;
            }
        }
        handledInstances.add(source);
        Collection<String> relatedPropertyNames = metaData.getRelPropertyNames(source.getClass());
        for (String propertyName : relatedPropertyNames) {
            Object clientValue;
            if (DataServiceUtils.isRelatedMany(objectAccess.getPropertyType(source.getClass(), propertyName)) || (clientValue = objectAccess.getProperty(source, propertyName)) == null) continue;
            clientValue = DataServiceUtils.mergeForInsert(clientValue, session, metaData, false, handledInstances);
            objectAccess.setProperty(source, propertyName, clientValue);
        }
        return source;
    }

    public static Tuple.Two<String, Boolean> getQueryType(String type) {
        Boolean isList = Boolean.FALSE;
        int i = type.indexOf("<");
        if (i > -1) {
            int j = type.indexOf(">");
            isList = Boolean.TRUE;
            type = type.substring(i + 1, j);
        }
        return Tuple.tuple((Object)type, (Object)isList);
    }

    public static MatchMode parseMatchMode(String matchMode) {
        MatchMode rtn = null;
        if (matchMode == null) {
            throw new IllegalArgumentException("matchMode cannot be null");
        }
        if (matchMode.equalsIgnoreCase("anywhere")) {
            rtn = MatchMode.ANYWHERE;
        } else if (matchMode.equalsIgnoreCase("exact")) {
            rtn = MatchMode.EXACT;
        } else if (matchMode.equalsIgnoreCase("start")) {
            rtn = MatchMode.START;
        } else if (matchMode.equalsIgnoreCase("end")) {
            rtn = MatchMode.END;
        } else {
            throw new IllegalArgumentException("MatchMode must be anywhere|exact|start|end");
        }
        return rtn;
    }

    public static Properties loadDBProperties(String resourcename) {
        return DataServiceUtils.loadDBProperties(resourcename, "_");
    }

    public static Properties loadDBProperties(File file) {
        return DataServiceUtils.loadDBProperties(file, "_");
    }

    private static Properties loadDBProperties(String resourcename, String sep) {
        Tuple.Two<String, String> t = DataServiceUtils.getBaseName(resourcename, sep);
        Properties base = SystemUtils.loadPropertiesFromResource((String)((String)t.v1 + "." + (String)t.v2));
        Properties rtn = SystemUtils.loadPropertiesFromResource((String)resourcename);
        rtn.putAll((Map<?, ?>)base);
        return rtn;
    }

    private static Properties loadDBProperties(File file, String sep) {
        String filepath = file.getAbsolutePath();
        Tuple.Two<String, String> t = DataServiceUtils.getBaseName(filepath, sep);
        Properties rtn = new Properties();
        File basefile = new File((String)t.v1 + "." + (String)t.v2);
        if (basefile.exists()) {
            rtn = SystemUtils.loadPropertiesFromFile((String)basefile.getAbsolutePath());
        }
        rtn.putAll((Map<?, ?>)SystemUtils.loadPropertiesFromFile((String)filepath));
        return rtn;
    }

    private static Tuple.Two<String, String> getBaseName(String resourcename, String sep) {
        String ext = StringUtils.fromLastOccurrence((String)resourcename, (String)".");
        String s = StringUtils.fromLastOccurrence((String)resourcename, (String)".", (int)-1);
        return Tuple.tuple((Object)StringUtils.fromLastOccurrence((String)s, (String)sep, (int)-1), (Object)ext);
    }

    private static void setup(Configuration cfg, Properties p) {
        p = DataServiceUtils.toHibernateConnectionProperties(p);
        cfg.setProperties(p);
    }

    private static boolean containsElementType(Collection<ElementType> elementTypes, ElementType elementType) {
        for (ElementType et : elementTypes) {
            if (!elementType.getJavaType().equals(et.getJavaType())) continue;
            return true;
        }
        return false;
    }

    private DataServiceUtils() {
        throw new UnsupportedOperationException();
    }
}

