/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.util;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.WMAppContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHandler
implements InvocationHandler {
    private Object target;
    private boolean tenantAdded;
    private Configuration cfg;

    public QueryHandler(Configuration cfg) {
        this.cfg = cfg;
    }

    public QueryHandler(Object target, Configuration cfg) {
        this.target = target;
        this.cfg = cfg;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String methodName = m.getName();
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        if (!(methodName.equals("save") || methodName.equals("update") || methodName.equals("delete") || methodName.equals("contains") || methodName.equals("getNamedQuery") || methodName.equals("get") || methodName.equals("createQuery") || methodName.equals("createSQLQuery"))) {
            return m.invoke(this.target, args);
        }
        WMAppContext wmApp = WMAppContext.getInstance();
        String tFldName = wmApp.getTenantFieldName();
        int tid = RuntimeAccess.getInstance().getTenantId();
        boolean tidExists = true;
        if (tid == -1) {
            tid = wmApp.getDefaultTenantID();
        }
        this.tenantAdded = false;
        if (methodName.equalsIgnoreCase("createQuery")) {
            String qryStr = this.modifySQL(args[0], tFldName, tid);
            Query qry = (Query)m.invoke(this.target, qryStr);
            if (this.tenantAdded) {
                qry.setInteger("wmtidval", tid);
            }
            return qry;
        }
        if (methodName.equalsIgnoreCase("createSQLQuery")) {
            String qryStr = this.modifySQL(args[0], tFldName, tid);
            SQLQuery sqlqry = (SQLQuery)m.invoke(this.target, qryStr);
            if (this.tenantAdded) {
                sqlqry.setInteger("wmtidval", tid);
            }
            return sqlqry;
        }
        if (methodName.equalsIgnoreCase("getNamedQuery")) {
            Map namedQueries = this.cfg.getNamedQueries();
            NamedQueryDefinition qd = (NamedQueryDefinition)namedQueries.get(args[0]);
            String qryStr = qd.getQuery();
            Query qry = (Query)m.invoke(this.target, args);
            if (qryStr.contains("wmtidval")) {
                qry.setInteger("wmtidval", tid);
            }
            return qry;
        }
        if (methodName.equalsIgnoreCase("get")) {
            int val;
            Object o = m.invoke(this.target, args);
            Class<?> cls = o.getClass();
            String t = tFldName.substring(0, 1).toUpperCase();
            String getterName = "get" + t + tFldName.substring(1);
            Method getter = null;
            try {
                getter = cls.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException ne) {
                tidExists = false;
            }
            if (tidExists && tid != (val = ((Integer)getter.invoke(o, new Object[0])).intValue())) {
                System.out.println("*** Security Viloation - Tenant ID mismatch ***");
                System.out.println("*** Tenant ID passed = " + tid + ", Tenant ID of Target Record = " + val + " ***");
                return null;
            }
            return o;
        }
        Object o = args[0];
        Class<?> cls = o.getClass();
        String s = tFldName.substring(0, 1).toUpperCase();
        String setterName = "set" + s + tFldName.substring(1);
        Method setter = null;
        try {
            setter = cls.getMethod(setterName, Integer.class);
        }
        catch (NoSuchMethodException ne) {
            tidExists = false;
        }
        if (tidExists) {
            setter.invoke(o, tid);
        }
        return m.invoke(this.target, args);
    }

    public static List<String> parseSQL(String qryStr) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        String twoLetters = null;
        boolean holdIt = false;
        for (int i = 0; i < qryStr.length(); ++i) {
            String aLetter = qryStr.substring(i, i + 1);
            if (holdIt) {
                if (twoLetters.equals("<") && (aLetter.equals("=") || aLetter.equals(">")) || twoLetters.equals(">") && aLetter.equals("=") || twoLetters.equals("|") && aLetter.equals("|") || twoLetters.equals("\r") && aLetter.equals("\n")) {
                    twoLetters = twoLetters + aLetter;
                    words.add(twoLetters);
                } else if (QueryHandler.isDelimiter(aLetter)) {
                    words.add(twoLetters);
                    words.add(aLetter);
                } else if (aLetter.equals(" ")) {
                    words.add(twoLetters);
                }
                holdIt = false;
                continue;
            }
            if (aLetter.equals("<") || aLetter.equals(">") || aLetter.equals("|") || aLetter.equals("\r")) {
                holdIt = true;
                twoLetters = aLetter;
                if (token.length() <= 0) continue;
                words.add(token.toString());
                token.setLength(0);
                continue;
            }
            if (QueryHandler.isDelimiter(aLetter)) {
                if (token.length() > 0) {
                    words.add(token.toString());
                    token.setLength(0);
                }
                words.add(aLetter);
                continue;
            }
            if (aLetter.equals(" ")) {
                if (token.length() <= 0) continue;
                words.add(token.toString());
                token.setLength(0);
                continue;
            }
            token.append(aLetter);
        }
        if (token.length() > 0) {
            words.add(token.toString());
        }
        return words;
    }

    public String modifySQL(Object o, String fieldName, int tid) {
        List<String> words = QueryHandler.parseSQL(o.toString());
        int len = words.size();
        int qid = -1;
        HashMap<Integer, SingleQuery> tm = new HashMap<Integer, SingleQuery>();
        int tidInsertPosition = 0;
        int openingInsertPosition = 0;
        boolean queryEndProcessed = false;
        boolean fieldInserted = false;
        boolean valueInserted = false;
        boolean addTIDValueForInsert = false;
        boolean inInsertFldList = false;
        boolean inInsertValueList = false;
        boolean firstStatement = true;
        StringBuffer sb = new StringBuffer();
        SingleQuery sq = null;
        for (int i = 0; i < len; ++i) {
            String word = words.get(i);
            if (this.byPassChar(word)) {
                sb.append(word);
                continue;
            }
            if (word.equalsIgnoreCase("select")) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                if (qid > -1) {
                    tm.put(qid, sq);
                }
                sq = new SingleQuery("select", ++qid, true);
                queryEndProcessed = false;
                if (inInsertFldList) {
                    tidInsertPosition = sb.length() + 1;
                    inInsertFldList = false;
                    addTIDValueForInsert = true;
                }
            } else if (word.equalsIgnoreCase("from")) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                if (sq == null || !sq.inQuery) {
                    if (qid > -1) {
                        tm.put(qid, sq);
                    }
                    sq = new SingleQuery("select", ++qid, true);
                }
                sq.inFrom = true;
                queryEndProcessed = false;
                sq.aliasNum = 0;
            } else if (word.equalsIgnoreCase("update") && firstStatement) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq = new SingleQuery("update", ++qid, true);
                queryEndProcessed = false;
                sq.inUpdate = true;
                sq.aliasNum = 0;
            } else if (word.equalsIgnoreCase("set")) {
                if (this.appendSpace((sb = sq.appendTableAlias(sb, words, i, fieldName)).toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq.inSet = true;
                sq.inUpdate = false;
            } else if (word.equalsIgnoreCase("delete") && firstStatement) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq = new SingleQuery("delete", ++qid, true);
                queryEndProcessed = false;
                sq.inDelete = true;
                sq.aliasNum = 0;
            } else if (word.equalsIgnoreCase("insert") && words.get(i + 1).equalsIgnoreCase("into") && i == 0) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq = new SingleQuery("insert", ++qid, true);
                queryEndProcessed = false;
            } else if (word.equalsIgnoreCase("into") && words.get(i - 1).equalsIgnoreCase("insert")) {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq.inInsert = true;
                sq.aliasNum = 0;
            } else if (word.equalsIgnoreCase("where")) {
                if (this.appendSpace((sb = sq.appendTableAlias(sb, words, i, fieldName)).toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                openingInsertPosition = sb.length() + 1;
                if (tidInsertPosition >= openingInsertPosition) {
                    ++tidInsertPosition;
                }
                sq.inWhere = true;
                sq.inFrom = false;
                sq.inUpdate = false;
                sq.inSet = false;
                sq.inDelete = false;
            } else if ((word.equalsIgnoreCase("group") || word.equalsIgnoreCase("order")) && words.get(i + 1).equalsIgnoreCase("by")) {
                if (!sq.tenantProcessed) {
                    if (sq.tableAliases.size() > 0) {
                        if (sq.inWhere) {
                            sb.insert(openingInsertPosition, "(");
                            if (tidInsertPosition >= openingInsertPosition) {
                                ++tidInsertPosition;
                            }
                            sb.append(") and (");
                            sb.append(this.insertTenantID(sq, fieldName));
                            sb.append(")");
                        } else {
                            sb.append(" where ");
                            sb.append(this.insertTenantID(sq, fieldName));
                        }
                    }
                    sq.tenantProcessed = true;
                }
                if (this.appendSpace((sb = sq.appendTableAlias(sb, words, i, fieldName)).toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq.inFrom = false;
                sq.inWhere = false;
                sq.inSet = false;
            } else if (word.equalsIgnoreCase("(")) {
                if (sq.inInsert && !inInsertFldList && !inInsertValueList) {
                    sq.inInsert = false;
                    inInsertFldList = true;
                }
                ++sq.openings;
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else if (word.equalsIgnoreCase(")")) {
                if (sq.openings <= 0) {
                    if (!queryEndProcessed) {
                        sb = sq.appendTableAlias(sb, words, i, fieldName);
                        if (!sq.tenantProcessed) {
                            if (sq.tableAliases.size() > 0) {
                                if (sq.inWhere) {
                                    sb.insert(openingInsertPosition, "(");
                                    if (tidInsertPosition >= openingInsertPosition) {
                                        ++tidInsertPosition;
                                    }
                                    sb.append(") and (");
                                    sb.append(this.insertTenantID(sq, fieldName));
                                    sb.append(")");
                                } else {
                                    sb.append(" where ");
                                    sb.append(this.insertTenantID(sq, fieldName));
                                }
                            }
                            sq.tenantProcessed = true;
                        }
                        sq.inFrom = false;
                        sq.inWhere = false;
                        sq.inUpdate = false;
                        sq.inSet = false;
                        sq.inDelete = false;
                        sq.inInsert = false;
                        sq.inQuery = false;
                        sq = (SingleQuery)tm.get(--qid);
                        queryEndProcessed = true;
                    }
                } else {
                    --sq.openings;
                }
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else if (word.equalsIgnoreCase("values")) {
                if (inInsertFldList) {
                    inInsertFldList = false;
                    inInsertValueList = true;
                }
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else if (word.equalsIgnoreCase("inner") || word.equalsIgnoreCase("left") || word.equalsIgnoreCase("right") || word.equalsIgnoreCase("full") || word.equalsIgnoreCase("join") || word.equalsIgnoreCase("fetch")) {
                if (this.appendSpace((sb = sq.appendTableAlias(sb, words, i, fieldName)).toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
                sq.inFrom = false;
            } else if (sq.queryType.equalsIgnoreCase("select") && sq.inFrom || sq.queryType.equalsIgnoreCase("update") && sq.inUpdate || sq.queryType.equalsIgnoreCase("delete") && sq.inDelete) {
                if (!(word.equalsIgnoreCase("as") || word.equalsIgnoreCase("\r\n") || word.equalsIgnoreCase("\n") || word.equalsIgnoreCase(","))) {
                    if (sq.alias) {
                        sq.addAliasNames(words, i, fieldName, word);
                        sq.alias = false;
                        sq.qryIncludeAlias = true;
                    } else {
                        sq.alias = true;
                    }
                }
                if (word.equalsIgnoreCase(",")) {
                    sb = sq.appendTableAlias(sb, words, i, fieldName);
                }
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else if (inInsertFldList && !fieldInserted) {
                sb.append(fieldName);
                sb.append(", ");
                fieldInserted = true;
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else if (inInsertValueList && !valueInserted) {
                sb.append(tid);
                sb.append(", ");
                valueInserted = true;
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            } else {
                if (this.appendSpace(sb.toString(), word)) {
                    sb.append(" ");
                }
                sb.append(word);
            }
            firstStatement = false;
        }
        if (sq.inFrom && !sq.qryIncludeAlias) {
            String aliasName = "table" + sq.aliasNum++;
            if (this.appendSpace(sb.toString(), aliasName)) {
                sb.append(" ");
            }
            sb.append(aliasName);
            sq.addAliasNames(words, len - 1, fieldName, aliasName);
        }
        if (!sq.tenantProcessed) {
            if (sq.tableAliases.size() > 0) {
                if (sq.inWhere) {
                    sb.insert(openingInsertPosition, "(");
                    if (tidInsertPosition >= openingInsertPosition) {
                        ++tidInsertPosition;
                    }
                    sb.append(") and (");
                    sb.append(this.insertTenantID(sq, fieldName));
                    sb.append(")");
                } else {
                    sb.append(" where ");
                    sb.append(this.insertTenantID(sq, fieldName));
                }
            }
            sq.tenantProcessed = true;
        }
        if (addTIDValueForInsert) {
            String tidfld = sq.tableAliases.get(0) + "." + fieldName + ", ";
            sb.insert(tidInsertPosition, tidfld);
        }
        return sb.toString();
    }

    private String insertTenantID(SingleQuery sq, String tField) {
        StringBuffer sb = new StringBuffer();
        int cnt = 0;
        for (String table : sq.tableAliases) {
            if (cnt > 0) {
                sb.append(" and ");
            }
            sb.append(table);
            sb.append(".");
            sb.append(tField);
            sb.append(" = :wmtidval");
            this.tenantAdded = true;
            ++cnt;
        }
        return sb.toString();
    }

    public static boolean isDelimiter(String val) {
        String[] list;
        for (String s : list = new String[]{"+", "-", "*", "/", "=", "<", ">", "!=", "(", ")", "\n", ",", "\r"}) {
            if (!s.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private boolean byPassChar(String val) {
        String[] list;
        for (String s : list = new String[]{"+", "-", "*", "/", "=", "<", ">", "!=", "\n", "\r"}) {
            if (!s.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private boolean appendSpace(String str, String word) {
        if (str.length() == 0 || str.endsWith("(") || str.endsWith(" ")) {
            return false;
        }
        return !word.startsWith(")") && !word.startsWith(",") && !word.startsWith(" ");
    }

    private boolean tenantFieldExists(String className, String fldName) {
        try {
            Iterator classList = this.cfg.getClassMappings();
            while (classList.hasNext()) {
                Class cls = ((PersistentClass)classList.next()).getMappedClass();
                String clsName = StringUtils.getClassName((String)cls.getName());
                if (!clsName.equals(StringUtils.getClassName((String)className))) continue;
                String s = fldName.substring(0, 1).toUpperCase();
                String setterName = "set" + s + fldName.substring(1);
                cls.getMethod(setterName, Integer.class);
                return true;
            }
        }
        catch (NoSuchMethodException ne) {
            return false;
        }
        return false;
    }

    private int getFirstNoneDelimiterPosBackward(int pos, List<String> words) {
        for (int i = pos; i > -1; --i) {
            if (QueryHandler.isDelimiter(words.get(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleQuery {
        String queryType;
        int parentQueryId;
        int queryId;
        int openings = 0;
        boolean inFrom = false;
        boolean inWhere = false;
        boolean inQuery = false;
        boolean inSet = false;
        boolean inUpdate = false;
        boolean inDelete = false;
        boolean inInsert = false;
        boolean tenantProcessed = false;
        boolean alias = false;
        int aliasNum = 0;
        boolean qryIncludeAlias = false;
        ArrayList<String> tableAliases = new ArrayList();

        private SingleQuery(String qtype, int qid, boolean flag) {
            this.queryType = qtype;
            this.queryId = qid;
            this.inQuery = flag;
        }

        private void addAliasNames(List<String> words, int indx, String fieldName, String alias) {
            int indx1 = QueryHandler.this.getFirstNoneDelimiterPosBackward(indx, words);
            if (indx1 < 0) {
                return;
            }
            int indx2 = QueryHandler.this.getFirstNoneDelimiterPosBackward(indx1 - 1, words);
            if (indx2 < 0) {
                return;
            }
            int indx3 = QueryHandler.this.getFirstNoneDelimiterPosBackward(indx2 - 1, words);
            String val1 = words.get(indx1);
            String val2 = words.get(indx2);
            String tableClassName = indx3 < 0 ? (!val2.equalsIgnoreCase("from") ? val2 : val1) : (val2.equalsIgnoreCase("as") ? words.get(indx3) : (!val2.equalsIgnoreCase("from") ? val2 : val1));
            if (QueryHandler.this.tenantFieldExists(tableClassName, fieldName)) {
                this.tableAliases.add(alias);
            }
        }

        private StringBuffer appendTableAlias(StringBuffer sb, List<String> words, int indx, String fieldName) {
            String tableClassName;
            if ((this.queryType.equalsIgnoreCase("select") && this.inFrom || this.queryType.equalsIgnoreCase("insert") && this.inInsert || this.queryType.equalsIgnoreCase("update") && this.inUpdate || this.queryType.equalsIgnoreCase("delete") && this.inDelete) && !this.qryIncludeAlias && QueryHandler.this.tenantFieldExists(tableClassName = words.get(indx - 1).equalsIgnoreCase("as") ? words.get(indx - 2) : words.get(indx - 1), fieldName)) {
                String aliasName = "table" + this.aliasNum++;
                if (QueryHandler.this.appendSpace(sb.toString(), aliasName)) {
                    sb.append(" ");
                }
                sb.append(aliasName);
                this.tableAliases.add(aliasName);
                this.alias = false;
            }
            return sb;
        }
    }
}

