/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.module;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.json.JSONArray;
import com.wavemaker.json.JSONObject;
import com.wavemaker.runtime.module.ModuleManager;
import com.wavemaker.runtime.module.ModuleWire;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleController
extends AbstractController {
    public static final String MODULES_PREFIX = "modules";
    public static final String MODULES_JS = "modules.js";
    public static final String EXTENSION_PATH = "ep";
    public static final String ID_PATH = "id";
    private ModuleManager moduleManager;

    protected Tuple.Two<ModuleWire, String> parseRequestPath(String requestURI) {
        ModuleWire mw;
        String path;
        String prefixEP = "/modules/ep/";
        String prefixID = "/modules/id/";
        if (requestURI.startsWith("/modules/ep/")) {
            int prefixEPLen = "/modules/ep/".length();
            int endExtLoc = requestURI.indexOf(47, prefixEPLen);
            String ep = requestURI.substring(prefixEPLen, endExtLoc);
            path = requestURI.substring(endExtLoc + 1);
            mw = this.moduleManager.getModule(ep);
        } else if (requestURI.startsWith("/modules/id/")) {
            int prefixIDLen = "/modules/id/".length();
            int endExtLoc = requestURI.indexOf(47, prefixIDLen);
            String id = endExtLoc == -1 ? requestURI.substring(prefixIDLen) : requestURI.substring(prefixIDLen, endExtLoc);
            mw = this.moduleManager.getModuleByName(id);
            path = requestURI.substring(endExtLoc + 1);
        } else {
            throw new WMRuntimeException(Resource.NO_MODULE_LOOKUP, new Object[]{requestURI});
        }
        return new Tuple.Two((Object)mw, (Object)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream is;
        block12: {
            String requestURI = request.getRequestURI();
            String moduleURI = "/modules";
            String moduleURIAbs = "/modules/";
            String moduleJsURI = "/modules/modules.js";
            String epURI = "/modules/ep";
            String epURIAbs = "/modules/ep/";
            String idURI = "/modules/id";
            String idURIAbs = "/modules/id/";
            if ("/modules".equals(requestURI = requestURI.substring(requestURI.indexOf(47, 1)))) return null;
            if ("/modules/".equals(requestURI)) return null;
            if ("/modules/ep".equals(requestURI) || "/modules/ep/".equals(requestURI)) {
                Set<String> names = this.moduleManager.listExtensionPoints();
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                ((Writer)writer).write("<html><body>\n");
                for (String ext : names) {
                    ((Writer)writer).write(ext + "<br />\n");
                }
                ((Writer)writer).write("</body></html>\n");
                ((Writer)writer).close();
                return null;
            }
            if ("/modules/id".equals(requestURI) || "/modules/id/".equals(requestURI)) {
                Set<String> names = this.moduleManager.listModules();
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                ((Writer)writer).write("<html><body>\n");
                for (String ext : names) {
                    ((Writer)writer).write(ext + "<br />\n");
                }
                ((Writer)writer).write("</body></html>\n");
                ((Writer)writer).close();
                return null;
            }
            if ("/modules/modules.js".equals(requestURI)) {
                Set<String> extensions = this.moduleManager.listExtensionPoints();
                JSONObject jo = new JSONObject();
                JSONObject extJO = new JSONObject();
                for (String extension : extensions) {
                    JSONArray ja = new JSONArray();
                    List<ModuleWire> wires = this.moduleManager.getModules(extension);
                    for (ModuleWire wire : wires) {
                        ja.add((Object)wire.getName());
                    }
                    extJO.put((Object)extension, (Object)ja);
                }
                jo.put((Object)"extensionPoints", (Object)extJO);
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                ((Writer)writer).write(jo.toString());
                ((Writer)writer).close();
                return null;
            }
            Tuple.Two<ModuleWire, String> tuple = this.parseRequestPath(requestURI);
            if (null == tuple.v1) {
                String message = Resource.NO_MODULE_RESOURCE.getMessage(new Object[]{requestURI, tuple.v2});
                this.logger.error((Object)message);
                response.setStatus(404);
                PrintWriter outputWriter = response.getWriter();
                ((Writer)outputWriter).write(message);
                return null;
            }
            URL url = this.moduleManager.getModuleResource((ModuleWire)tuple.v1, (String)tuple.v2);
            URLConnection conn = url.openConnection();
            if (SystemUtils.IS_OS_WINDOWS) {
                conn.setDefaultUseCaches(false);
            }
            response.setContentType(conn.getContentType());
            ServletOutputStream os = null;
            is = null;
            try {
                os = response.getOutputStream();
                is = conn.getInputStream();
                IOUtils.copy(conn.getInputStream(), (OutputStream)os);
                Object var21_35 = null;
                if (null == os) break block12;
            }
            catch (Throwable throwable) {
                Object var21_36 = null;
                if (null != os) {
                    os.close();
                }
                if (null == is) throw throwable;
                is.close();
                throw throwable;
            }
            os.close();
        }
        if (null == is) return null;
        is.close();
        return null;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }
}

