/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.ui.logout.LogoutFilter;
import org.acegisecurity.ui.logout.LogoutHandler;

public class AcegiAjaxLogoutFilter
extends LogoutFilter {
    private static final String ACEGI_AJAX_LOGOUT_REQUEST_PARAM = "acegiAjaxLogout";
    private static final String SUCCESS_URL = "url";

    public AcegiAjaxLogoutFilter(String logoutSuccessUrl, LogoutHandler[] handlers) {
        super(logoutSuccessUrl, handlers);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (this.isAjaxRequest(request)) {
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = request.getContextPath() + url;
            }
            String jsonContent = "{\"url\":\"" + url + "\"}";
            response.getOutputStream().write(jsonContent.getBytes());
        } else {
            super.sendRedirect(request, response, url);
        }
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getParameter(ACEGI_AJAX_LOGOUT_REQUEST_PARAM) != null;
    }
}

