/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.service.annotations.ExposeToClient;
import com.wavemaker.runtime.service.annotations.HideFromClient;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HideFromClient
public class JOSSOSecurityService {
    static final Logger logger = Logger.getLogger(JOSSOSecurityService.class);

    @ExposeToClient
    public String getUserName() {
        HttpServletRequest req = RuntimeAccess.getInstance().getRequest();
        if (req != null & this.isAuthenticated()) {
            return req.getUserPrincipal().getName();
        }
        return null;
    }

    @ExposeToClient
    public String getSessionAttributeName(String name) {
        HttpSession sess = RuntimeAccess.getInstance().getSession();
        if (sess != null) {
            Object value = sess.getAttribute(name);
            return value.toString();
        }
        return null;
    }

    @ExposeToClient
    public List<String> getSessionAttributeNames() {
        ArrayList<String> result = new ArrayList<String>();
        HttpSession sess = RuntimeAccess.getInstance().getSession();
        if (sess != null) {
            Enumeration Attributes = sess.getAttributeNames();
            while (Attributes.hasMoreElements()) {
                String name = (String)Attributes.nextElement();
                result.add(name);
            }
            return result;
        }
        return null;
    }

    @ExposeToClient
    public String getRequestAttributeName(String name) {
        HttpServletRequest req = RuntimeAccess.getInstance().getRequest();
        if (req != null) {
            Object value = req.getAttribute(name);
            return value.toString();
        }
        return null;
    }

    @ExposeToClient
    public List<String> getRequestAttributeNames() {
        ArrayList<String> result = new ArrayList<String>();
        HttpServletRequest req = RuntimeAccess.getInstance().getRequest();
        if (req != null) {
            Enumeration Attributes = req.getAttributeNames();
            while (Attributes.hasMoreElements()) {
                String name = (String)Attributes.nextElement();
                result.add(name);
            }
            return result;
        }
        return null;
    }

    @HideFromClient
    public boolean isAuthenticated() {
        HttpServletRequest req = RuntimeAccess.getInstance().getRequest();
        if (req != null) {
            return req.getUserPrincipal() != null;
        }
        return false;
    }
}

