/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;

public class LdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private boolean groupSearchDisabled;
    private String roleModel;
    private String roleEntity;
    private String roleTable;
    private String roleProperty;
    private String roleProvider;
    private String roleUsername;
    private String roleQuery;
    private DataSource dataSource;

    public LdapAuthoritiesPopulator(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
        super(initialDirContextFactory, groupSearchBase);
    }

    public Set getGroupMembershipRoles(String userDn, String username) {
        if (this.isGroupSearchDisabled()) {
            return new HashSet();
        }
        if (this.roleProvider != null && this.roleProvider.equals("Database")) {
            try {
                HashSet<GrantedAuthorityImpl> roles = new HashSet<GrantedAuthorityImpl>();
                Connection con = this.getDataSource().getConnection();
                String sqlStatement = "";
                sqlStatement = this.roleQuery != null && !this.roleQuery.equals("") ? this.roleQuery : "SELECT " + this.roleProperty.toLowerCase() + " FROM " + this.roleTable + " WHERE " + this.roleUsername + " = ?";
                PreparedStatement ps = con.prepareStatement(sqlStatement);
                ps.setString(1, username);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    GrantedAuthorityImpl grantedAuthorityImp = new GrantedAuthorityImpl("ROLE_" + rs.getString(1));
                    roles.add(grantedAuthorityImp);
                }
                return roles;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return new HashSet();
            }
        }
        return super.getGroupMembershipRoles(userDn, username);
    }

    public boolean isGroupSearchDisabled() {
        return this.groupSearchDisabled;
    }

    public void setGroupSearchDisabled(boolean groupSearchDisabled) {
        this.groupSearchDisabled = groupSearchDisabled;
    }

    public String getRoleModel() {
        return this.roleModel;
    }

    public void setRoleModel(String roleModel) {
        this.roleModel = roleModel;
    }

    public String getRoleEntity() {
        return this.roleEntity;
    }

    public void setRoleEntity(String roleEntity) {
        this.roleEntity = roleEntity;
    }

    public String getRoleTable() {
        return this.roleTable;
    }

    public void setRoleTable(String roleTable) {
        this.roleTable = roleTable;
    }

    public String getRoleProperty() {
        return this.roleProperty;
    }

    public void setRoleProperty(String roleProperty) {
        this.roleProperty = roleProperty;
    }

    public String getRoleProvider() {
        return this.roleProvider;
    }

    public void setRoleProvider(String roleProvider) {
        this.roleProvider = roleProvider;
    }

    public String getRoleUsername() {
        return this.roleUsername;
    }

    public String getRoleQuery() {
        return this.roleQuery;
    }

    public void setRoleQuery(String roleQuery) {
        this.roleQuery = roleQuery;
    }

    public void setRoleUsername(String roleUsername) {
        this.roleUsername = roleUsername;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

