/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.security;

import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.runtime.security.InvalidCredentialsException;
import com.wavemaker.runtime.security.Resource;
import com.wavemaker.runtime.security.Rule;
import com.wavemaker.runtime.security.SecurityException;
import com.wavemaker.runtime.service.annotations.ExposeToClient;
import com.wavemaker.runtime.service.annotations.HideFromClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HideFromClient
public class SecurityService {
    static final Logger logger = Logger.getLogger(SecurityService.class);
    private AuthenticationManager authenticationManager;
    private String rolePrefix;
    private String noRolesMarkerRole;
    private List<String> roles;
    private Map<String, List<Rule>> roleMap;

    public void authenticate(String username, String password) throws InvalidCredentialsException, SecurityException {
        Authentication auth = null;
        try {
            auth = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        }
        catch (BadCredentialsException e) {
            throw new InvalidCredentialsException(e);
        }
        catch (AuthenticationException e) {
            throw new SecurityException(e);
        }
        SecurityContextHolder.getContext().setAuthentication(auth);
    }

    @ExposeToClient
    public void logout() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private Authentication getAuthenticatedAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof AnonymousAuthenticationToken ? null : authentication;
    }

    @ExposeToClient
    public boolean isAuthenticated() {
        return this.getAuthenticatedAuthentication() != null;
    }

    @ExposeToClient
    public String getUserName() {
        WMAppContext wmApp = WMAppContext.getInstance();
        return wmApp.getUserNameForUserID(this.getUserId());
    }

    @ExposeToClient
    public String getUserId() {
        Authentication authentication = this.getAuthenticatedAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return null;
    }

    @ExposeToClient
    public String[] getUserRoles() {
        Authentication authentication = this.getAuthenticatedAuthentication();
        if (authentication == null) {
            return new String[0];
        }
        GrantedAuthority[] authorities = authentication.getAuthorities();
        ArrayList<String> roleNames = new ArrayList<String>();
        for (GrantedAuthority authority : authorities) {
            String roleName = authority.getAuthority();
            String realRoleName = null;
            if (this.rolePrefix == null) {
                realRoleName = roleName;
            } else if (roleName.startsWith(this.rolePrefix)) {
                realRoleName = roleName.substring(this.rolePrefix.length());
            } else {
                logger.warn((Object)("Skipping Role " + roleName + ". It should be prefix with " + this.rolePrefix + ". Something is wrong!"));
            }
            if (realRoleName == null || realRoleName.equals(this.noRolesMarkerRole)) continue;
            roleNames.add(realRoleName);
        }
        WMAppContext wmApp = WMAppContext.getInstance();
        if (wmApp != null && wmApp.isMultiTenant()) {
            Integer tid = wmApp.getTenantIdForUser(this.getUserName());
            RuntimeAccess.getInstance().setTenantId(tid);
        }
        return roleNames.toArray(new String[0]);
    }

    public boolean isAllowed(Set<Resource> resources, String action) {
        String[] roleNames;
        for (String roleName : roleNames = this.getUserRoles()) {
            if (this.isAllowed(roleName, resources, action)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowed(String roleName, Set<Resource> resources, String action) {
        List<Rule> rules = this.roleMap.get(roleName);
        if (rules != null) {
            for (Rule rule : rules) {
                if (!action.equals(rule.getAction())) continue;
                for (Resource ruleResource : rule.getResources()) {
                    for (Resource queryResource : resources) {
                        if (!queryResource.matchResource(ruleResource) || rule.isAllowed()) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getNoRolesMarkerRole() {
        return this.noRolesMarkerRole;
    }

    public void setNoRolesMarkerRole(String noRolesMarkerRole) {
        this.noRolesMarkerRole = noRolesMarkerRole;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Map<String, List<Rule>> getRoleMap() {
        return this.roleMap;
    }

    public void setRoleMap(Map<String, List<Rule>> roleMap) {
        this.roleMap = roleMap;
    }
}

