/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.server;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.wavemaker.common.Resource;
import com.wavemaker.common.WMException;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.ClassUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.json.JSONState;
import com.wavemaker.runtime.server.ParamName;
import com.wavemaker.runtime.service.ParsedServiceArguments;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.runtime.service.annotations.ExposeToClient;
import com.wavemaker.runtime.service.annotations.HideFromClient;
import com.wavemaker.runtime.service.events.ServiceEventNotifier;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.springframework.aop.support.AopUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtils {
    protected static final Logger logger = Logger.getLogger(ServerUtils.class);
    static final Pattern extensionPattern = Pattern.compile("^(.*)\\.(download|upload|flashUploader|json)$");

    private ServerUtils() {
    }

    public static String getFileName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (-1 != uri.lastIndexOf(47)) {
            uri = uri.substring(uri.lastIndexOf(47) + 1);
        }
        return uri;
    }

    public static String getServiceName(HttpServletRequest request) {
        String fileName = ServerUtils.getFileName(request);
        Matcher matcher = extensionPattern.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getDirectory(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (-1 != uri.lastIndexOf(47)) {
            uri = uri.substring(0, uri.lastIndexOf(47));
        }
        if (0 == "".compareTo(uri)) {
            uri = "/";
        }
        return uri;
    }

    public static String readInput(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        if (null == is) {
            throw new WMRuntimeException("no input stream found in request");
        }
        String input = IOUtils.toString((InputStream)is, "UTF-8");
        is.close();
        return input;
    }

    public static List<String> getParameterNames(Method method) {
        String[] methodParameterNames;
        int numParams = method.getParameterTypes().length;
        ArrayList<String> ret = new ArrayList<String>(numParams);
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Class paramNameClass = ClassLoaderUtils.loadClass((String)ParamName.class.getName(), (ClassLoader)method.getDeclaringClass().getClassLoader());
        try {
            AdaptiveParanamer ap = new AdaptiveParanamer();
            methodParameterNames = ap.lookupParameterNames((AccessibleObject)method);
            ap = null;
        }
        catch (ParameterNamesNotFoundException e) {
            logger.info((Object)("No parameter names found for method " + method.getName()));
            methodParameterNames = new String[numParams];
        }
        for (int i = 0; i < numParams; ++i) {
            String paramName = null;
            if (null == paramName) {
                for (Annotation ann : paramAnnotations[i]) {
                    if (!paramNameClass.isAssignableFrom(ann.annotationType())) continue;
                    try {
                        Method nameMethod = paramNameClass.getMethod("name", new Class[0]);
                        paramName = (String)nameMethod.invoke((Object)ann, new Object[0]);
                        break;
                    }
                    catch (SecurityException e) {
                        throw new WMRuntimeException((Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new WMRuntimeException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new WMRuntimeException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new WMRuntimeException((Throwable)e);
                    }
                }
            }
            if (null == paramName && null != methodParameterNames) {
                paramName = methodParameterNames[i];
            }
            if (null == paramName) {
                logger.warn((Object)("no parameter name information for parameter " + i + ", method: " + method.getName()));
                paramName = "arg-" + (i + 1);
            }
            ret.add(paramName);
        }
        return ret;
    }

    public static String getMethod(Map<String, Object[]> params) {
        Object[] methodO;
        String method = null;
        if (params.containsKey("method") && (methodO = params.get("method")) instanceof String[] && 1 == ((String[])methodO).length) {
            method = ((String[])methodO)[0];
        }
        if (null == method) {
            throw new WMRuntimeException(Resource.SERVER_NOMETHODORID, new Object[]{params});
        }
        params.remove("method");
        return method;
    }

    public static Map<String, Object[]> mergeParams(HttpServletRequest request) {
        Set entries;
        HashMap<String, Object[]> params = new HashMap<String, Object[]>();
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
            entries = mrequest.getFileMap().entrySet();
            for (Map.Entry e : entries) {
                params.put((String)e.getKey(), new Object[]{e.getValue()});
            }
        }
        entries = request.getParameterMap().entrySet();
        for (Map.Entry e : entries) {
            String key = (String)e.getKey();
            Object[] value = (Object[])e.getValue();
            if (null == params.get(key)) {
                params.put(key, (Object[])e.getValue());
                continue;
            }
            Object[] newArray = new Object[value.length + ((Object[])params.get(key)).length];
            System.arraycopy(params.get(key), 0, newArray, 0, ((Object[])params.get(key)).length);
            System.arraycopy(value, 0, newArray, ((Object[])params.get(key)).length, value.length);
            params.put(key, newArray);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypedServiceReturn invokeMethodWithEvents(ServiceEventNotifier serviceEventNotifier, ServiceWire sw, String method, ParsedServiceArguments args, JSONState jsonState, boolean throwExceptions) throws WMException {
        TypedServiceReturn ret = null;
        try {
            NDC.push((String)("invoke " + sw.getServiceId() + "." + method));
            Throwable exception = null;
            if (logger.isDebugEnabled()) {
                StringBuilder logMessage = new StringBuilder();
                logMessage.append("Invoking method \"" + method + "\" with translated parameters: [");
                for (Object arg : args.getArguments()) {
                    logMessage.append(arg);
                    if (null != arg) {
                        logMessage.append(" (" + arg.getClass() + ")");
                    }
                    logMessage.append(", ");
                }
                logMessage.append("]");
                logger.debug((Object)logMessage.toString());
            }
            args.setArguments(serviceEventNotifier.executePreOperation(sw, method, args.getArguments()));
            try {
                ret = sw.getServiceType().invokeMethod(sw, method, args, jsonState);
            }
            catch (Throwable t) {
                if (throwExceptions) {
                    throw new WMRuntimeException(t);
                }
                exception = SystemUtils.unwrapInternalException((Throwable)t);
            }
            try {
                ret = serviceEventNotifier.executePostOperation(sw, method, ret, exception);
            }
            catch (Throwable t) {
                if (t instanceof WMException) {
                    throw (WMException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                String msg = StringUtils.fromLastOccurrence((String)t.getClass().getName(), (String)".");
                if (t.getMessage() != null) {
                    msg = msg + ": " + t.getMessage();
                }
                throw new WMRuntimeException(msg, t);
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            NDC.pop();
            throw throwable;
        }
        NDC.pop();
        return ret;
    }

    public static Class<?> getRealClass(Object o) {
        Class<?> ret = AopUtils.isAopProxy((Object)o) ? AopUtils.getTargetClass((Object)o) : o.getClass();
        return ret;
    }

    public static List<Method> getClientExposedMethods(Class<?> klass) {
        List allMethods = ClassUtils.getPublicMethods(klass);
        ArrayList<Method> ret = new ArrayList<Method>(allMethods.size());
        ClassLoader cl = klass.getClassLoader();
        Class hideFromClient = ClassLoaderUtils.loadClass((String)HideFromClient.class.getCanonicalName(), (ClassLoader)cl);
        Class exposeToClient = ClassLoaderUtils.loadClass((String)ExposeToClient.class.getCanonicalName(), (ClassLoader)cl);
        if (null != klass.getAnnotation(hideFromClient)) {
            for (Method meth : allMethods) {
                if (null == meth.getAnnotation(exposeToClient)) continue;
                ret.add(meth);
            }
        } else {
            for (Method meth : allMethods) {
                if (null != meth.getAnnotation(hideFromClient)) continue;
                ret.add(meth);
            }
        }
        return ret;
    }

    public static String getServerTimeOffset() {
        Calendar now = Calendar.getInstance();
        int totalOffset = now.get(15) + now.get(16);
        return Integer.toString(totalOffset);
    }
}

