/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.GenericFieldDefinition;
import com.wavemaker.json.type.OperationEnumeration;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ListReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ObjectReflectTypeDefinition;
import com.wavemaker.json.type.reflect.PrimitiveReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementType
implements Cloneable {
    private String name;
    private String javaType;
    private boolean isList;
    private boolean allowNull;
    private boolean supportsQuickData;
    private String subType;
    private List<OperationEnumeration> require = new ArrayList<OperationEnumeration>();
    private List<OperationEnumeration> noChange = new ArrayList<OperationEnumeration>();
    private List<OperationEnumeration> exclude = new ArrayList<OperationEnumeration>();
    private String service;
    private List<ElementType> properties = new ArrayList<ElementType>();
    private boolean isTopLevel = false;

    public ElementType(String javaType) {
        this(null, javaType);
    }

    public ElementType(Class<?> javaType) {
        this(null, javaType);
    }

    public ElementType(String name, String javaType) {
        this(name, javaType, false);
    }

    public ElementType(String name, Class<?> javaType) {
        this(name, javaType, false);
    }

    public ElementType(String name, String javaType, boolean isList) {
        this.name = name;
        this.javaType = javaType;
        this.isList = isList;
    }

    public ElementType(String name, Class<?> javaType, boolean isList) {
        this(name, javaType.getName(), isList);
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors(javaType);
        ArrayList<ElementType> elements = new ArrayList<ElementType>(pds.length);
        for (PropertyDescriptor pd : pds) {
            ElementType element;
            Type type;
            Class<?> klass;
            if (pd.getName().equals("class") || null == pd.getReadMethod() && null == pd.getWriteMethod()) continue;
            if (null != pd.getReadMethod()) {
                klass = pd.getReadMethod().getReturnType();
                type = pd.getReadMethod().getGenericReturnType();
            } else {
                klass = pd.getWriteMethod().getParameterTypes()[0];
                type = pd.getWriteMethod().getGenericParameterTypes()[0];
            }
            if (klass.isArray()) {
                element = new ElementType(pd.getName(), klass.getComponentType().getName(), true);
            } else if (Collection.class.isAssignableFrom(klass) && type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Type aType = ptype.getActualTypeArguments()[0];
                element = new ElementType(pd.getName(), ((Class)aType).getName(), true);
            } else {
                element = new ElementType(pd.getName(), klass.getName());
            }
            elements.add(element);
        }
        this.properties = elements;
    }

    public ElementType(String name, String javaType, boolean isList, List<ElementType> properties) {
        this.name = name;
        this.javaType = javaType;
        this.isList = isList;
        this.properties = properties;
    }

    public ElementType(String name, Class<?> javaType, boolean isList, List<ElementType> properties) {
        this(name, javaType.getName(), isList, properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public boolean isList() {
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public List<ElementType> getProperties() {
        return this.properties;
    }

    public void addProperty(ElementType property) {
        this.properties.add(property);
    }

    public void setProperties(List<ElementType> properties) {
        this.properties = properties;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public void setTopLevel(boolean isTopLevel) {
        this.isTopLevel = isTopLevel;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public boolean isSupportsQuickData() {
        return this.supportsQuickData;
    }

    public void setSupportsQuickData(boolean supportsQuickData) {
        this.supportsQuickData = supportsQuickData;
    }

    public String toString() {
        return this.javaType;
    }

    public List<OperationEnumeration> getRequire() {
        return this.require;
    }

    public void setRequire(List<OperationEnumeration> require) {
        this.require = require;
    }

    public List<OperationEnumeration> getNoChange() {
        return this.noChange;
    }

    public void setNoChange(List<OperationEnumeration> noChange) {
        this.noChange = noChange;
    }

    public List<OperationEnumeration> getExclude() {
        return this.exclude;
    }

    public void setExclude(List<OperationEnumeration> exclude) {
        this.exclude = exclude;
    }

    public FieldDefinition toFieldDefinition() {
        GenericFieldDefinition ret = new GenericFieldDefinition();
        Class klass = null;
        try {
            if (null != this.getJavaType()) {
                klass = ClassUtils.forName((String)this.getJavaType());
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!this.getProperties().isEmpty()) {
            ObjectReflectTypeDefinition ortd = new ObjectReflectTypeDefinition();
            ortd.setTypeName(this.getJavaType());
            for (ElementType et : this.getProperties()) {
                ortd.getFields().put(et.getName(), et.toFieldDefinition());
            }
            ret.setTypeDefinition((TypeDefinition)ortd);
        } else if (null != klass) {
            ret = (GenericFieldDefinition)ReflectTypeUtils.getFieldDefinition((Type)klass, (TypeState)new ReflectTypeState(), (boolean)false, null);
        } else {
            PrimitiveReflectTypeDefinition prtd = new PrimitiveReflectTypeDefinition();
            prtd.setTypeName(this.getJavaType());
            ret.setTypeDefinition((TypeDefinition)prtd);
        }
        if (null != ret.getTypeDefinition()) {
            ((ReflectTypeDefinition)ret.getTypeDefinition()).setLiveService(this.isSupportsQuickData());
            ((ReflectTypeDefinition)ret.getTypeDefinition()).setShortName(this.getName());
        }
        if (this.isList()) {
            ArrayList<ListReflectTypeDefinition> listType = new ArrayList<ListReflectTypeDefinition>();
            ListReflectTypeDefinition lrtd = new ListReflectTypeDefinition();
            lrtd.setKlass(List.class);
            lrtd.setTypeName(List.class.getName());
            listType.add(lrtd);
            ret.setArrayTypes(listType);
        }
        ret.setNoChange(this.getNoChange());
        ret.setExclude(this.getExclude());
        ret.setRequire(this.getRequire());
        ret.setName(this.getName());
        ret.setAllowNull(this.isAllowNull());
        ret.setSubType(this.getSubType());
        return ret;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

