/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.service;

public class Filter {
    private static final String FORMAT_ERROR = "filter must be of format: <property>=<value>";
    private static final String FILTER_SEP = "=";
    private final String propertyPath;
    private final String expression;

    public static Filter newInstance(String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        int i = filter.indexOf(FILTER_SEP);
        if (i == -1 || i == 0) {
            throw new IllegalArgumentException(FORMAT_ERROR);
        }
        String propertyPath = filter.substring(0, i);
        String expression = "";
        if (i < filter.length() - 1) {
            expression = filter.substring(i + 1);
        }
        return new Filter(propertyPath, expression);
    }

    public Filter(String propertyPath, String expression) {
        this.propertyPath = propertyPath;
        this.expression = expression;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.propertyPath + FILTER_SEP + this.expression;
    }
}

